#ifndef H_CDW_CONFIG_UI_INTERNALS
#define H_CDW_CONFIG_UI_INTERNALS

#include <stdbool.h>

#include "main.h"
#include "cdw_config.h"
#include "cdw_widgets.h"

cdw_rv_t cdw_config_ui_window_create(cdw_config_t *config, bool tools_page_is_visible);
cdw_rv_t cdw_config_ui_window_pages_driver(cdw_config_t *tmp_config);
void cdw_config_ui_window_destroy(void);

/* declaration of type */
struct cdw_config_ext_tools_dropdowns_t {
	CDW_DROPDOWN *cdrecord;
	CDW_DROPDOWN *mkisofs;
	CDW_DROPDOWN *growisofs;
	CDW_DROPDOWN *dvd_rw_mediainfo;
	CDW_DROPDOWN *dvd_rw_format;
	CDW_DROPDOWN *dvd_family;
};

/* field indexes for page A of configuration window - "writing" */
enum {
	f_general_l = 0,
	f_blank_l,
	f_blank_cb,
	f_eject_l,
	f_eject_cb,
	f_speed_l,
	f_speed_dd,
	f_dummy_l,
	f_dummy_cb,
	f_cdrecord_l,
	f_pad_l,
	f_pad_cb,
	f_pad_size_l,
	f_pad_size_i,
	f_burnproof_l,
	f_burnproof_cb,
	f_oco_l,
	f_oco_i,
	f_growisofs_l,
	f_ogo_l,
	f_ogo_i
	} page_A_indexes;

/* field indexes for page B of configuration window - "hardware" */
enum {
	f_selected_drive_l = 0,
	f_selected_drive_dd,
	f_custom_drive_l,
	f_custom_drive_i,
	f_scsi_l,
	f_scsi_i
	/* f_mountpoint_l,
	f_mountpoint_i,
	f_cdrom_l,
	f_cdrom_i */ } page_B_indexes;

/* field indexes for page C of configuration window - "audio" */
enum {
	f_audiodir_l = 0,
	f_audiodir_i,
	f_audiodir_b } page_C_indexes;

/* field indexes for page D of configuration window - "iso filesystem" */
enum {
	f_volumeid_l = 0,
	f_volumeid_i,
	f_showvol_l,
	f_showvol_cb,
	f_iso_level_l,
	f_iso_level_dd,
	f_joliet_l,
	f_joliet_cb,
	f_rockridge_l,
	f_rockridge_cb,
	f_useful_rr_l,
	f_useful_rr_cb,
	f_joliet_long_l,
	f_joliet_long_cb,
	f_follow_symlinks_l,
	f_follow_symlinks_cb,
	f_iso_image_full_path_l,
	f_iso_image_full_path_i,
	f_iso_image_full_path_b, /* button calling file picker */
	f_boot_disc_options_l,
	f_boot_disc_options_i,
	f_omo_l,
	f_omo_i } page_D_indexes;

/* field indexes for page E of configuration window - "tools" */
enum {
	f_manual_selection_l = 0,
	f_manual_selection_cb,
	f_dvd_family_l,
	f_dvd_family_dd,
	f_mkisofs_path_l,
	f_mkisofs_path_dd,
	f_cdrecord_path_l,
	f_cdrecord_path_dd,
	f_growisofs_path_l,
	f_growisofs_path_dd,
	f_dvd_rw_mediainfo_path_l,
	f_dvd_rw_mediainfo_path_dd,
	f_dvd_rw_format_path_l,
	f_dvd_rw_format_path_dd } page_E_indexes;


/* field indexes for page F of configuration window - "log" + other settings */
enum {
	f_log_fp_l = 0,
	f_log_fp_i,
	f_log_fp_b,
	f_showlog_l,
	f_showlog_cb,
	f_volume_size_l,
	f_volume_size_dd,   /* dropdown */
	f_cust_volume_size_l,
	f_cust_volume_size_i   /* "custom value" input field */
} page_F_indexes;

#endif /* #ifndef H_CDW_CONFIG_UI_INTERNALS */

