/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * A few small modifications (C) 2007 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>

#include <ncursesw/ncurses.h>
#include <ncursesw/menu.h>
#include <ncursesw/form.h>

#include <fcntl.h>
#include <libintl.h>
#include <locale.h>
#include <mcheck.h>
#include <string.h>
#include <unistd.h>


#include "help.h"
#include "options.h"
#include "log.h"
#include "config.h"
#include "color.h"
#include "gettext.h"
#include "commands.h"
#include "cdda2wav.h"
#include "cdw_ui.h"
#include "main.h"
#include "utils.h"
#include "cdw_tmp_files.h"
#include "thread.h"

#ifdef GTK_GUI
#include "gtkgui.h"
#endif

#define COLOR_GRAY

extern WINDOW *mainwin;
extern MENU *menu;
extern MENU *cdmenu;


void clean_before_cdw_exit(void);
int cdw_main_loop(void);


/* global across files */
int num; 
struct conf config; 


int DEBUGMSG = 0;




int main(int argc, char *argv[])
{
	int rv; /* return value variable */

	mtrace();

	/* Read cdw configuration file */
	config = read_conf();

	set_cdw_locale();

	/* creating new processes in threads code may create some zombie processes */
	set_zombie_handler();

	/* list of files to be written */
	filelist_init();

	tmpfiles_init();

	/* application name string for main app window */
	cdw_title_init();

	if (argc > 1) {
		process_commandline_args(argc, argv);
	}

	/* initialize ncurses */
	rv = cdw_curses_init();
	if (rv == -1) {
		clean_before_cdw_exit();
		printf(_("Needed min 80x25 terminal!"));
		exit(-1);
	}

	put_mainform(); /* main app window */

	select_window(TRUE);

	// initially cursor is on first left-hand menu item, but tooltips are
	// displayed only after cursor movement; show tooltip for initial
	// cursor position
	display_tooltip(0);

	cdw_main_loop();

	/* 
	 * now let's unwind (almost) all setup code 
	 * called before cdw_main_loop(); we will do this in 
	 * one nice function - clean_before_cdw_exit() - since we 
	 * have already it
	 */
	clean_before_cdw_exit();

	return 0;
}




/*
 * Deallocate all previously allocated resources, terminate ncurses
 *
 * Try to do this in order reverse to the one found in main().
 */
void clean_before_cdw_exit(void)
{
	clean_title();

	filelist_clean();

	destroy_mainform();

	endwin();

	return;
}




/*
 * Here most of action happens
 *
 * This is main ncurses events loop.
 *
 * \returns 0
 */
int cdw_main_loop(void)
{
	char command[555];
	int c;

	while ((c = wgetch(mainwin)) != 'q') {
		switch (c) {

			/* -------- HOT KEYS -------- */
#ifdef HAVE_LIBMYSQLCLIENT
		case 'c':
		case 'C':
			// CDDB
			cddb_window();
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(FALSE);
			break;
#endif
#ifdef HAVE_LIBSQLITE
		case 'c':
		case 'C':
			/* CDDB */
			cddb_window();
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(FALSE);
			break;
#endif
		case 'e':
		case 'E':
			/* eject tray */
			eject_tray(config.cdrwdevice);
			break;
#if 0 // not in this release
		case 'g':
		case 'G':
			/* cdda2wav */
			cdda2wav(mainwin, &config);
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
#endif
		case KEY_F(1):
			/*  Show readme */
			/* sprintf(command, "%s/README.gz", DOCDIR);
			 * log_window(_("Help"), command, 1); */
			show_help_main();
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
		case KEY_F(2):
			/* Edit volume ID */
			input_box(_("Volume ID"), _("Enter volume label:"), config.volumeid, 0);
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
		case KEY_F(3):
			/* Edit other parameters */
			input_box(_("CD record parameters"), _("Enter parameter:"), config.other, 0);
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
		case KEY_F(4):
			/* CD size select */
			size_selector();
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
		case 'L':
		case 'l':
		case KEY_F(5):
			/* Show last log */
			log_window(_("Last log"), config.logfile, 0);
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
		case KEY_F(6):
			/* Show CD info */
			sprintf(command, "%s dev=%s -atip", CDRECORD, config.scsi);
			run_command(command, _("Load CD info..."), 0, 0, 0, "");
			log_window(_("CD info"), config.logfile, 0);
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
/*	    case KEY_F(9):
		dialogbox("This is a sample message. Show in a simple\ndialog box\n\nOk?", "Dialog box", 3);
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;*/

		case KEY_F(10):
			/* Show GPL */
			sprintf(command, "%s/LICENSE", DOCDIR);
			log_window(_("License"), command, 1);
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
#ifdef HAVE_LIBMYSQLCLIENT
		case 'A':
		case 'a':
			/* Add disk to dic database */
			add_to_dic();
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
#endif
#ifdef HAVE_LIBSQLITE
		case 'A':
		case 'a':
			/* Add disk to dic database */
			add_to_dic();
			wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
			select_window(TRUE);
			break;
#endif
			/* -------- MENU -------- */

		case KEY_HOME:
			menu_driver(menu, REQ_FIRST_ITEM);
			display_tooltip(item_index(current_item(menu)));
			break;
		case KEY_END:
			menu_driver(menu, REQ_LAST_ITEM);
			display_tooltip(item_index(current_item(menu)));
			break;
		case KEY_DOWN:
			menu_driver(menu, REQ_DOWN_ITEM);
			display_tooltip(item_index(current_item(menu)));
			break;
		case KEY_UP:
			menu_driver(menu, REQ_UP_ITEM);
			display_tooltip(item_index(current_item(menu)));
			break;
		case 10: /* ENTER */
			// FIXME - replace 0, 1, 2 etc. with symbolic names
			/* Add files */
			if (item_index(current_item(menu)) == 0) {
				put_addwin(getmaxy(mainwin) - 10, getmaxx(mainwin) - 10, (LINES - (getmaxy(mainwin) - 10)) / 2, (COLS - (getmaxx(mainwin) - 10)) / 2);
				wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
				select_window(TRUE);
			}
			/* Delete files */
			if (item_index(current_item(menu)) == 1) {
				/* If cd files not empty! */
				if (num > 0) {
					set_menu_fore(cdmenu, COLOR_PAIR(1) | A_REVERSE);
					set_menu_fore(menu, COLOR_PAIR(4));
					wrefresh(mainwin);
					delete_files();
					set_menu_fore(cdmenu, COLOR_PAIR(1));
					set_menu_fore(menu, COLOR_PAIR(4) | A_REVERSE);
				} else {
					dialogbox("Nothing to delete - no files selected.", "No files to delete", DIALOG_OK);
					/// wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
					/// select_window(FALSE);
				}
			}

			/* Create image */
			if ((item_index(current_item(menu)) == 2)) {
				if (num > 0) { /* there are some files on 'selected files' list */
					int rv = run_command_create_image();
					if (rv != 0) {
						break; // FIXME - why break?
					}
				} else {
					dialogbox("No files selected. Please use 'Add files'", "No files selected", DIALOG_OK);
					/// wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
					///select_window(FALSE);
				}
			}

#if 0 // not in this release
			/* Copy image */
			if ((item_index(current_item(menu)) == 3)) {
				int exist = 0;
				FILE *isofile;

				if ((isofile = fopen(config.tempdir, "r")) != NULL) {
					exist = dialogbox(_("copy: Image file exist!\nDo you wish to overwrite it?"), _("Image exist"), 3);
					fclose(isofile);
				}

				// erase 'Image exists' dialog box window 
				wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
				select_window(FALSE);

				if (disc_in_drive()) {
					if (exist == 0) {
						copy_image(_("Copy CD image"));
					}
					wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
					select_window(FALSE);
					wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
					select_window(FALSE);
				}
				wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
				select_window(FALSE);
			}
#endif
			/* Write to disk */
			if (item_index(current_item(menu)) == 3) {
				if (!disc_in_drive()) {
					break;
				}

				if (strcmp(config.fromimage, "1") == 0) {
					if (access(config.tempdir, R_OK) == 0) {
						/* Write from image */
						run_command_write_from_image();
					} else {
						dialogbox("No image file. Please check your options.", "No image file", DIALOG_OK);
						/// wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
					}
				} else if ((strcmp(config.fromimage, "0") == 0)) {
					if ( ! filelist_empty() ){
						/* Write directly from filesystem, based on list of selected files */
						run_command_write_direct();
					} else {
						dialogbox("No files to write. Use \"Add files\".", "No files to write", DIALOG_OK);
						/// wrefresh(mainwin);
						/// wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
					}
				} else { // is it really necessary?
					;
				}
			}
#if 0 // not in this release
			/* Write Audio */
			if ((item_index(current_item(menu)) == 5)) {
				run_command_write_audio();
			}
			/* Copy data CD */
			if ((item_index(current_item(menu)) == 6) && (config.cdrom != config.cdrwdevice)) {
				run_command_copy_disk();
			}
#endif
			/* Blank CD-RW */
			if (item_index(current_item(menu)) == 4) {
				if (!disc_in_drive()) {
					break;
				}

				// check if disc is erasable;
				// possible answers:
				// yes (rv = 0), don't know (rv = 0), no (rv != 0)
				int rv = run_command_check_erasable();
				if (rv == 0) {
					int rv = run_command_blank_cd();
					wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
					select_window(FALSE);
					if (rv == 0) { // blanking successful
						eject_tray(config.cdrom);
						close_tray(config.cdrom);
					}
				} else {
					dialogbox("Disc in drive is not erasable. I cannot blank it", "Media not erasable", 0);
					/// wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
					/// select_window(FALSE);
				}
					
			}
			/* Edit cdw options */
			if (item_index(current_item(menu)) == 5) {
				options_window();
				config = read_conf();
				wrefresh(derwin(mainwin, LINES - 1, COLS - 1, 0, 0));
				select_window(FALSE);
				fill_info();
			}
			/* Quit */
			if (item_index(current_item(menu)) == 6) {
				clean_before_cdw_exit();
				exit(EXIT_SUCCESS);
			}
			break;
		}
		wrefresh(mainwin);
	}

	return 0;
}


