#ifndef __CDROM_CTRL_H
#define __CDROM_CTRL_H

#include <linux/cdrom.h>
#include <sys/ioctl.h>


// redefining CDW_* values here so we don't have to include 
// <linux/cdrom.h> every time when we want to use cdrom_ctrl cdrom_status()
#define CDW_CD_NO_INFO CDS_NO_INFO
#define CDW_CD_NO_DISC  CDS_NO_DISC
#define CDW_CD_TRAY_OPEN CDS_TRAY_OPEN
#define CDW_CD_DRIVE_NOT_READY CDS_DRIVE_NOT_READY
#define CDW_CD_DISC_OK CDS_DISC_OK

void eject_tray(char *device);
void close_tray(char *device);
int cdrom_status(void);
bool disc_in_drive(void);



#endif // __CDROM_CTRL_H
