/*
 * exec.c
 *
 * Copyright (C) 2004 Bastian Blank <waldi@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $LastChangedBy: bastian $
 * $LastChangedDate: 2004-09-19 12:03:45 +0200 (Sun, 19 Sep 2004) $
 * $LastChangedRevision: 628 $
 */

#include <config.h>

#include <debian-installer.h>

#include "execute.h"
#include "install.h"
#include "log.h"

const char *environment[] =
{
  "DEBIAN_FRONTEND=noninteractive",
  "PATH=",
  "http_proxy=",
  "ftp_proxy=",
  NULL
};

static int execute_io_handler (const char *buf, size_t n __attribute__ ((unused)), void *user_data __attribute__ ((unused)))
{ 
  log_text (DI_LOG_LEVEL_OUTPUT, "%s", buf);
  return 0;
}

static int execute_real (const char *const command, di_io_handler *stdout_handler, di_io_handler *stderr_handler, void *io_user_data, di_process_handler *child_prepare_handler, void *child_prepare_user_data)
{
  const char *const argv[] = { "sh", "-c", command, NULL };
  int ret = di_exec_env_full ("/bin/sh", argv, environment, stdout_handler, stderr_handler, io_user_data, NULL, NULL, child_prepare_handler, child_prepare_user_data);
  log_text (DI_LOG_LEVEL_DEBUG, "Return code: %d", ret);
  return ret;
}

int execute (const char *const command)
{
  return execute_full (command, execute_io_handler, execute_io_handler, NULL, NULL, NULL);
}

int execute_full (const char *const command, di_io_handler *stdout_handler, di_io_handler *stderr_handler, void *io_user_data, di_process_handler *child_prepare_handler, void *child_prepare_user_data)
{
  log_text (DI_LOG_LEVEL_DEBUG, "Execute \"%s\"", command);
  return execute_real (command, stdout_handler, stderr_handler, io_user_data, child_prepare_handler, child_prepare_user_data);
}

int execute_target (const char *command)
{
  return execute_target_full (command, execute_io_handler, execute_io_handler, NULL);
}

int execute_target_full (const char *const command, di_io_handler *stdout_handler, di_io_handler *stderr_handler, void *io_user_data)
{
  log_text (DI_LOG_LEVEL_DEBUG, "Execute \"%s\" in chroot", command);
  return execute_real (command, stdout_handler, stderr_handler, io_user_data, di_exec_prepare_chroot, install_root);
}

int execute_init (char *const *envp)
{
  const char **t1;
  char *const *t2;

  t1 = environment;
  while (*t1)
  {
    size_t l = strlen (*t1);
    if ((*t1)[l - 1] == '=')
    {
      t2 = envp;
      while (*t2)
      {
        if (strncmp (*t1, *t2, l) == 0)
        {
          *t1 = *t2;
          break;
        }
        t2++;
      }
    }
    t1++;
  }

  return 0;
}

