/*
 * check.c
 *
 * Copyright (C) 2003 Bastian Blank <waldi@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $LastChangedBy: bastian $
 * $LastChangedDate: 2004-06-06 12:33:27 +0200 (Sun, 06 Jun 2004) $
 * $LastChangedRevision: 429 $
 */

#include <config.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "check.h"
#include "frontend.h"
#include "suite.h"

int check_deb (const char *target, di_package *p, const char *message)
{
  return check_md5 (target, p->md5sum, message);
}

int check_md5 (const char *target, const char *md5sum, const char *message)
{
  int ret;
  FILE *in;
  char buf[1024];

  log_message (LOG_MESSAGE_INFO_DOWNLOAD_VALIDATE, message);

  snprintf (buf, sizeof (buf), "/usr/bin/md5sum %s\n", target);

  in = popen (buf, "r");
  fgets (buf, sizeof (buf), in);

  ret = pclose (in);
  if (ret)
    return 1;

  if (!strncmp (buf, md5sum, 32))
    return 0;
  return 1;
}

static int check_packages_file (const char *target, const char *file, di_release *rel)
{
  di_release_file *item;
  di_rstring key;

  key.string = (char *) file;
  key.size = strlen (file);
  item = di_hash_table_lookup (rel->md5sum, &key);
  if (!item)
    log_text (DI_LOG_LEVEL_ERROR, "Can't find checksum for Packages file");
  return check_md5 (target, item->sum, "Packages");
}

int check_packages (const char *target, di_release *rel)
{
  char buf[128];

  snprintf (buf, sizeof (buf), "main/binary-%s/Packages", arch);
  return check_packages_file (target, buf, rel);
}

int check_packages_extension (const char *target, const char *extension, di_release *rel)
{
  char buf[128];
  char buf_target[1024];

  snprintf (buf, sizeof (buf), "main/binary-%s/Packages.%s", arch, extension);
  snprintf (buf_target, sizeof (buf_target), "%s.%s", target, extension);
  return check_packages_file (buf_target, buf, rel);
}

