/*
 * download.h
 *
 * Copyright (C) 2003 Bastian Blank <waldi@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $LastChangedBy: bastian $
 * $LastChangedDate: 2004-03-01 17:00:17 +0100 (Mon, 01 Mar 2004) $
 * $LastChangedRevision: 257 $
 */

#ifndef DOWNLOAD_H
#define DOWNLOAD_H

#include <debian-installer.h>

#include <stdio.h>

#include "install.h"
#include "packages.h"
#include "suite.h"

static inline int build_target_deb_root (char *buf, size_t size, const char *file)
{
  snprintf (buf, size, "/var/cache/apt/archives/%s", file);
  return 0;
}

static inline int build_target_deb (char *buf, size_t size, const char *file)
{
  snprintf (buf, size, "%s/var/cache/apt/archives/%s", install_root, file);
  return 0;
}

static inline int build_source_indices_packages (char *buf, size_t size)
{
  snprintf (buf, size, "dists/%s/main/binary-%s/Packages", suite_name, arch);
  return 0;
}

static inline int build_target_indices_packages (char *buf, size_t size)
{
  snprintf (buf, size,
            "%s/var/lib/apt/lists/debootstrap.invalid_dists_%s_main_binary-%s_Packages",
            install_root, suite_name, arch);
  return 0;
}

static inline int build_source_indices_release (char *buf, size_t size)
{
  snprintf (buf, size, "dists/%s/Release", suite_name);
  return 0;
}

static inline int build_target_indices_release (char *buf, size_t size)
{
  snprintf (buf, size, "%s/var/lib/apt/lists/debootstrap.invalid_dists_%s_Release", install_root, suite_name);
  return 0;
}

int download (di_packages **packages, di_packages_allocator *allocator, di_slist **install);

int download_init (void);

#endif
