/****************************************************************************
                             Hyper's CD Catalog 
		A multiplatform qt and xml based catalog program
  
 Author    : Peter Deak (hyperr@freemail.hu)
 License   : GPL
 Copyright : (C) 2003 Peter Deak
****************************************************************************/

#ifndef CDCAT_WDBFILE
#define CDCAT_WDBFILE

#include <stdio.h>
#include <expat.h>
#include <zlib.h>

class Node;
class PWw;
class QString;

const char *getSType  (int t);
const char *getMType  (int t);
float       getSizeFS (const char *str);
int         getSizetFS(const char *str);
int         getTypeFS (const char *str);


class FileWriter
 {
  private:
   gzFile f;
   int level;
   
  public:
   FileWriter(gzFile ff,bool nicefp);
     
   PWw *pww;
   int writeDown(Node *source);
   bool nicef;
  
  private:
   const char *spg(int spn);
   void commentWriter (char *c);

   int  writeHeader   (void);
   int  writeCatalog  (Node *source);
   int  writeMedia    (Node *source);
   int  writeDirectory(Node *source);
   int  writeFile     (Node *source);
   int  writeMp3Tag   (Node *source);
   int  writeContent  (Node *source);
 }; 


class FileReader
 {
  private:
   gzFile f;
  public:
   
   PWw *pww;
   QString errormsg;    
   int  error;
   int  insert;
 
   Node *sp;
   char *dataBuffer;
   

   int   readFrom (Node *source);
   float  getFloat(const char **from,char *what,char *err);
   char * getStr  (const char **from,char *what,char *err);
   int    isthere (const char **from,char *what);
   FileReader(gzFile ff,int ins = 0)
     { f = ff; insert=ins; }   
   
 };

#endif
