/****************************************************************************
                            Hyper's CD Catalog
	A multiplatform qt and xml based catalog program
 
Author    : Christoph Thielecke <crissi99@gmx.de>
License   : GPL
Copyright : (C) 2003 Christoph Thielecke
****************************************************************************/


#include "importdialog.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <stdio.h>
#include <stdlib.h>
#include <qvariant.h>


ImportDialog::ImportDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
		: QDialog( parent, name, modal, fl ) {
	if ( !name )
		setName( "ImportDialog" );

        QVBoxLayout *vbl = new QVBoxLayout(this,10,5);


        setSizeGripEnabled(true);
	info_lab = new QLabel( this, "info_lab" );
	info_lab->setText( "info" );
	vbl->addWidget(info_lab);

         
	QHBoxLayout *hbl1 = new QHBoxLayout();

	filename_lab = new QLabel( this, "filename_lab" );
	hbl1->addWidget(filename_lab);

	filename_lineedit = new QLineEdit( this, "filename_lineedit" );
	hbl1->addWidget(filename_lineedit);

	buttonGetFile = new QPushButton( this, "buttonGetFile" );
	hbl1->addWidget(buttonGetFile);
        vbl->addLayout(hbl1);
    
    
	importButtonBox = new QButtonGroup(1,Qt::Horizontal,tr("Type"),this,"import_button_box");
	importButtonBox->setRadioButtonExclusive(true);
	importTypeText = new QRadioButton(  "&Text",importButtonBox, "importTypeText");
	importTypeXml = new QRadioButton( "&XML",importButtonBox ,"importTypeXml");

	vbl->addWidget(importButtonBox);

	newdatabase = new QCheckBox( this, "newdatabase" );
	newdatabase->setText( tr( "Create new Database" ) );
	vbl->addWidget(newdatabase);
	
	
	QHBoxLayout *hbl2 = new QHBoxLayout();
	
	seperator_lab = new QLabel( this, "seperator_lab" );
	hbl2->addWidget(seperator_lab);
	
	seperator_lineedit = new QLineEdit( this, "seperator_lineedit" );
	seperator_lineedit->setMinimumSize( QSize( 0, 0 ) );
	seperator_lineedit->setMaximumSize( QSize( 20, 32767 ) );
	seperator_lineedit->setMaxLength ( 1 );
        hbl2->addWidget( seperator_lineedit);
        vbl->addLayout(hbl2);

	correctbadstyle = new QCheckBox( this, "correctbadstyle" );
	correctbadstyle->setText( tr( "Correct bad style of gtktalog export" ) );
        vbl->addWidget(correctbadstyle);

        QHBoxLayout *hbl3 = new QHBoxLayout();
	
	buttonOK = new QPushButton( this, "buttonOK" );
	buttonOK->setDefault( true );
	buttonOK-> setMinimumWidth( 100 );

	buttonCancel = new QPushButton( this, "buttonCancel" );
	buttonCancel-> setMinimumWidth( 100 );
	vbl->addSpacing(18);
	hbl3->addSpacing(30);
	hbl3->addWidget(buttonOK);
	hbl3->addWidget(buttonCancel);
	hbl3->addSpacing(30);
	vbl->addLayout(hbl3);
	vbl->addSpacing(10);
	
	
	
	importTypeXml->setChecked(true);
	correctbadstyle->setEnabled(false);
	seperator_lab->setEnabled(false);
	seperator_lineedit->setEnabled(false);



	languageChange();
	resize( QSize( 450, 210 ).expandedTo( minimumSizeHint() ) );
	setMinimumSize(minimumSizeHint());

	//clearWState( WState_Polished );

	connect( buttonOK, SIGNAL( clicked() ), this, SLOT( bOk() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( bCan() ) );
	connect( buttonGetFile, SIGNAL( clicked() ), this, SLOT( getFileName() ) );
	connect( importTypeText, SIGNAL( clicked() ), this, SLOT( typeChanged() ) );
	connect( importTypeXml, SIGNAL( clicked() ), this, SLOT( typeChanged() ) );

 	seperator_lab->setEnabled(false);
	seperator_lineedit->setEnabled(false);

	


}

/*
 *  Destroys the object and frees any allocated resources
 */
ImportDialog::~ImportDialog() {
	//no need to delete child widgets, Qt does it for us!
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void ImportDialog::languageChange() {
	setCaption( tr( "Import CSV file" ) );
	filename_lab->setText( tr( "File:" ) );

	seperator_lineedit->setText( ";" );
	seperator_lab->setText( tr( "Seperator:" ) );
	QToolTip::add
		( seperator_lineedit , tr( "This is the seperator in dataline\n<path>SEPERATOR<size>SEPERATOR<date><space><time>" ) );
	QWhatsThis::add
		( seperator_lineedit , tr( "Seperator in data line" ) );
	buttonCancel->setText( tr( "Cancel" ) );
	buttonOK->setText( tr( "Import" ) );
	buttonGetFile->setText("...");

	importButtonBox->setTitle(tr("Type"));
	importTypeText->setText(tr("&Text (CSV)"));
	importTypeXml->setText(tr("&XML (gtktalog)"));

	QToolTip::add
		( importButtonBox , tr( "Select the type of import" ) );

	QToolTip::add
		( importTypeText , tr( "Select this for importing text file (CSV)" ) );

	QToolTip::add
		( importTypeXml , tr( "Select this for importing a XML report generated with gtktalog" ) );

	QToolTip::add
		( buttonGetFile , tr( "File dialog for selecting file to import." ) );
	QWhatsThis::add
		( buttonGetFile , tr( "Open file dialog" ) );
	QToolTip::add
		( correctbadstyle , tr( "Corrects bad output style of gtktalog.\n<media>SEPERATOR/<dir>/SEPERATOR/<dir>\n will be to\n<media>/<dir>/<dir>" ) );
	QWhatsThis::add
		( correctbadstyle , tr( "Corrects bad output style (gtktalog)" ) );
	info_lab->setText( tr( "<strong>Please read the README_IMPORT before you import!</strong>" ) );

	
	
}

int ImportDialog::bOk( void ) {
	if ( ( filename_lineedit->text() ).isEmpty() ) {
		QMessageBox::warning( this, tr( "Error:" ), tr( "You must fill the \"Filename\" field!" ), tr( "Ok" ), 0 );
		return 0;
	}

	if (importTypeText->isChecked() && seperator_lineedit->text().isEmpty()) {
		QMessageBox::warning( this, tr( "Error:" ), tr( "You must fill the \"Seperator\" field!" ), tr( "Ok" ), 0 );
		return 0;
	}

	filename = filename_lineedit->text();
	seperator = seperator_lineedit->text();
	createdatabase = newdatabase->isChecked();
	if ( importTypeText->isChecked() )
		type = 0;
	if ( importTypeXml->isChecked() )
		type = 1;
	
	OK = 1;
		
	close();
	return 0;
}

int ImportDialog::bCan( void ) {
	OK = 0;
	close();
	return 0;
}

void ImportDialog::getFileName() {
	QString filetypes;

	if (importTypeText->isChecked())
		filetypes = QString (tr ( "csv files(*.csv)"));
	else
		filetypes = QString(tr ( "xml files(*.xml)"));

	filename_lineedit->setText( QFileDialog::getOpenFileName(
	                                getenv( "HOME" ),
	                                //     "/data/compile/CdCat-0.91/",
	                                filetypes,
	                                0,
	                                tr ( "open file dialog" ),
	                                tr ( "Choose a file for import" ) ) );

	filename= filename_lineedit->text();
}

void ImportDialog::typeChanged() {
	if (importTypeText->isChecked()) {
		correctbadstyle->setEnabled(true);
		seperator_lab->setEnabled(true);
		seperator_lineedit->setEnabled(true);

	} else {
		correctbadstyle->setEnabled(false);
		seperator_lab->setEnabled(false);
		seperator_lineedit->setEnabled(false);
	}

}
