/**
 * @file mem.h
 * Memory transfer primitives
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/*
 * Copyright  1994-1996 Marko Mkel and Olaf Seibert
 * Copyright  2001 Marko Mkel
 * Original Linux and Commodore 64/128/Vic-20 version by Marko Mkel
 * Ported to the PET and the Amiga series by Olaf Seibert
 * Restructured by Marko Mkel
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/** save a memory area
 * @param comm		the communication primitives
 * @param bank		memory bank (0=normal)
 * @param start		start address (inclusive)
 * @param end		end address (exclusive)
 * @param buf		(output) the saved data
 * @return		zero on success, nonzero on error
 */
int
save (const struct comm* comm,
      unsigned bank, unsigned start, unsigned end,
      void* buf);

/** load a memory area
 * @param comm		the communication primitives
 * @param bank		memory bank (0=normal)
 * @param start		start address (inclusive)
 * @param end		end address (exclusive)
 * @param buf		the data to be loaded
 * @return		zero on success, nonzero on error
 */
int
load (const struct comm* comm,
      unsigned bank, unsigned start, unsigned end,
      const void* buf);
