;;; @file nonebase.s
;;; Basic definitions for no memory expansion
;;; @author Marko Mkel (msmakela@nic.funet.fi)

	;; increment and compare pointers
#define plain_incmptr_decl incmptr \
	inc start:.(:bne nohi:inc start+1:nohi:.):\
	lda start:cmp end:.(:bne ne:lda start+1:cmp end+1:ne:.):rts
	;; block transfers
#if host = 128
#define WR_INIT LDY0R:lda pokeptr:pha:lda #start:sta pokeptr
#define WR_FINI sty bank:pla:sta pokeptr
#define WR_DO ldx bank:jsr poke
#define RD_INIT lda peekptr:pha:lda #start:sta peekptr
#define RD_FINI sty bank:pla:sta peekptr
#define RD_DO1
#define RD_DO2 ldx bank:jsr peek
#else
#define WR_INIT LDY0R
#define WR_FINI
#define WR_DO sta (start),y
#define RD_INIT LDY0R
#define RD_FINI
#if host = 64 /* read in a 64kB RAM config */
#define RD_DO1 ldx 1
#define RD_DO2 lda #$3c:sta 1:lda (start),y:stx 1
#else
#define RD_DO1
#define RD_DO2 lda (start),y
#endif
#endif
	;; load a memory block
#define plain_load \
	WR_INIT:.(:loop jsr receive:WR_DO:jsr incmptr:bne loop:.):WR_FINI

	;; save a memory block
#if s_switch
#define plain_save \
	RD_INIT:RD_DO1:RD_DO2:jsr send_switch:jsr incmptr:.(:beq skip:\
	RD_DO1:loop RD_DO2:jsr send:jsr incmptr:bne loop:skip:.):RD_FINI
#else
#define plain_save \
	RD_INIT:RD_DO1:.(:loop RD_DO2:jsr send:jsr incmptr:bne loop:.):RD_FINI
#endif
