#
# $Header: /cvsroot/catalog/catalog/t/03mifluz.t,v 1.7 2001/07/11 10:28:08 loic Exp $
#
use strict;

package main;

use Test;

use Catalog::tools::tools;
use Catalog::dmoz;

require "t/lib.pl";
require "t/fulltext.pl";

#$::opt_verbose = 'hook|normal';
#$::opt_verbose = 'mifluz|normal';
$::opt_error_stack = 1;

conftest_generic();

#
# Do not do anything if mifluz was not chosen
#
{
    my($fulltext_conf) = load_config("conf/fulltext.conf");
    if(!exists($fulltext_conf->{'fulltext_type'}) ||
       $fulltext_conf->{'fulltext_type'} ne 'mifluz') {
	print STDERR " skip ";
	plan test => 1;
	ok(1, 1, "fake");
	exit(0);
    }
}

require Catalog::tools::mifluz;

fulltext_prepare();

plan test => 7;

{
    my($mifluz) = Catalog::tools::mifluz->new();
    ok(defined($mifluz), 1, "create mifluz object");
    ok($mifluz->exec("insert a 1 2 3 4"), 1, "insert a");
    my($result, $ntuples) = $mifluz->select("select a");
    ok(defined($result), 1, "select a returned defined result");
    ok($ntuples, 1, "ntuples should be 1");
    ok(exists($result->[0]->{'match'}), 1, "select a returned a match");
    my($match) = $result->[0]->{'match'};
    ok($match->Get(3), 3, "third numerical field value should be 3");
    ok($mifluz->exec("delete a 1 2 3 4"), 1, "delete a");
    $mifluz->logoff();
}

fulltext_clean();
conftest_generic_clean();

# Local Variables: ***
# mode: perl ***
# End: ***
