/*
 * Copyright 2009 Ralf Joachim, Ahmad Hassan
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.castor.cpa.persistence.sql.query;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

import org.junit.Ignore;

/**
 * Mock object to test QueryContext.
 * 
 * @author <a href="mailto:ahmad DOT hassan AT gmail DOT com">Ahmad Hassan</a>
 * @author <a href="mailto:ralf DOT joachim AT syscon DOT eu">Ralf Joachim</a>
 * @version $Revision$ $Date: 2006-04-25 15:08:23 -0600 (Tue, 25 Apr 2006) $
 */
@Ignore
public final class PreparedStatementMock implements PreparedStatement {
    private int _lastIndex = 0;

    public int getLastParameterIndex() {
        return _lastIndex;
    }
    
    public void setNull(final int index, final int sqlType) {
        _lastIndex = index;
    }

    public void addBatch() { }

    public void addBatch(final String sql) { }

    public void cancel() { }

    public void clearBatch() { }

    public void clearParameters() { }

    public void clearWarnings() { }

    public void close() { }

    public boolean execute() {
        return false;
    }

    public boolean execute(final String sql) {
        return false;
    }

    public boolean execute(final String sql, final int autoGeneratedKeys) {
        return false;
    }

    public boolean execute(final String sql, final int[] columnIndexes) {
        return false;
    }

    public boolean execute(final String sql, final String[] columnNames) {
        return false;
    }

    public int[] executeBatch() {
        return null;
    }

    public ResultSet executeQuery() {
        return null;
    }

    public ResultSet executeQuery(final String sql) {
        return null;
    }

    public int executeUpdate() {
        return 0;
    }

    public int executeUpdate(final String sql) {
        return 0;
    }

    public int executeUpdate(final String sql, final int autoGeneratedKeys) {
        return 0;
    }

    public int executeUpdate(final String sql, final int[] columnIndexes) {
        return 0;
    }

    public int executeUpdate(final String sql, final String[] columnNames) {
        return 0;
    }

    public Connection getConnection() {
        return null;
    }

    public int getFetchDirection() {
        return 0;
    }

    public int getFetchSize() {
        return 0;
    }

    public ResultSet getGeneratedKeys() {
        return null;
    }

    public int getMaxFieldSize() {
        return 0;
    }

    public int getMaxRows() {
        return 0;
    }

    public ResultSetMetaData getMetaData() {
        return null;
    }

    public boolean getMoreResults() {
        return false;
    }

    public boolean getMoreResults(final int current) {
        return false;
    }

    public ParameterMetaData getParameterMetaData() {
        return null;
    }

    public int getQueryTimeout() {
        return 0;
    }

    public ResultSet getResultSet() {
        return null;
    }

    public int getResultSetConcurrency() {
        return 0;
    }

    public int getResultSetHoldability() {
        return 0;
    }

    public int getResultSetType() {
        return 0;
    }

    public int getUpdateCount() {
        return 0;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void setArray(final int index, final Array x) { }

    public void setAsciiStream(final int index, final InputStream x, final int length) { }

    public void setBigDecimal(final int index, final BigDecimal x) { }

    public void setBinaryStream(final int index, final InputStream x, final int length) { }

    public void setBlob(final int index, final Blob x) { }

    public void setBoolean(final int index, final boolean x) { }

    public void setByte(final int index, final byte x) { }

    public void setBytes(final int index, final byte[] x) { }

    public void setCharacterStream(final int index, final Reader reader, final int length) { }

    public void setClob(final int index, final Clob x) { }

    public void setCursorName(final String name) { }

    public void setDate(final int index, final Date x) { }

    public void setDate(final int index, final Date x, final Calendar cal) { }

    public void setDouble(final int index, final double x) { }

    public void setEscapeProcessing(final boolean enable) { }

    public void setFetchDirection(final int direction) { }

    public void setFetchSize(final int rows) { }

    public void setFloat(final int index, final float x) { }

    public void setInt(final int index, final int x) { }

    public void setLong(final int index, final long x) { }

    public void setMaxFieldSize(final int max) { }

    public void setMaxRows(final int max) { }

    public void setNull(final int index, final int sqlType, final String typeName) { }

    public void setObject(final int index, final Object x) { }

    public void setObject(final int index, final Object x, final int type) { }

    public void setObject(final int index, final Object x, final int type, final int size) { }

    public void setQueryTimeout(final int seconds) { }

    public void setRef(final int index, final Ref x) { }

    public void setShort(final int index, final short x) { }

    public void setString(final int index, final String x) { }

    public void setTime(final int index, final Time x) { }

    public void setTime(final int index, final Time x, final Calendar cal) { }

    public void setTimestamp(final int index, final Timestamp x) { }

    public void setTimestamp(final int index, final Timestamp x, final Calendar cal) { }

    @Deprecated
    public void setUnicodeStream(final int index, final InputStream x, final int length) { }

    public void setURL(final int index, final URL x) { }
}
