import pygame
from pygame.locals import *
from Numeric import *

import common
from game import get_game
from field import Castle
from player import BasePlayer

class SelectPlayer(BasePlayer):

	select_pic = common.load_image("castleselect.png", alpha=True)

	def __init__(self, player):
		self.player = player

	def init(self):
		self.selected = 0
		self.castles = filter(lambda castle: castle.player is self.player, Castle.instances)
		self.finished = False

	def draw_cursor(self):
		if self.finished:
			return
		draw_at = multiply( add(self.castles[self.selected].pos, (-4, -4)), common.block_size)
		common.blit(SelectPlayer.select_pic, draw_at)

	def remote_select_castle(self, change):
		self.selected += change
		if self.selected not in range(0, len(self.castles)):
			self.selected %= len(self.castles)

	def remote_confirm_select(self):
		self.castles[self.selected].big = True
		pos = self.castles[self.selected].pos
		# build wall
		x_bound = (pos[0] - 3, pos[0] + 4)
		y_bound = (pos[1] - 3, pos[1] + 4)
		for x in range(x_bound[0], x_bound[1] + 1):
			for y in range(y_bound[0], y_bound[1] + 1):
				if x in x_bound or y in y_bound:
					get_game().field[x][y] = self.player.player_id
		# update screen
		get_game().field.look_for_secured_areas(self.player)
		get_game().field.draw_backbuffer()
		# disable player
		self.finished = True

	def handle_event(self, event):
		if self.finished:
			return
		if (event.type == KEYDOWN):
			keys = self.player.config.keys
			if event.key in (keys.up, keys.right):
				self.call("select_castle", -1)
			elif event.key in (keys.down, keys.left):
				self.call("select_castle", 1)
			elif event.key == keys.button[0]:
				self.call("confirm_select")
			elif event.key == keys.button[1]:
				pass
			else:
				catched = False

	def handle_movement(self, passed_milliseconds):
		pass
	
