import pygame
from pygame.locals import *
from Numeric import *
from twisted.spread import pb

import common

class Pause:

	def __init__(self):
		pass
	
	def run(self):
		pass
	
	def cleanup(self):
		pass

class Game(pb.Referenceable):

	def __init__(self, number_of_players, server=None):
		class DummyPhase:
			phase_name = "none"

		global game
		game = self
		self.server = server
		self.number_of_players = number_of_players
		self.players = []
		self.phase = DummyPhase()
		import player
		for i in range(self.number_of_players):
			self.players.append(player.Player(i))
			
		import field
		self.field = field.Field()

		# empty instance lists
		self.cannons = []
		self.shots = []
		from field import Castle, Grunt
		Castle.instances = []	
		Grunt.instances = []

	def print_time(self):
		time = int( max(self.phase.time_left, 0) )
		time_surface = common.font.render(str(time), True, (0,0,0))
		common.blit(time_surface, ((common.screen.get_width()-time_surface.get_width())/2, 0) )

	def get_wall(self, pos):
		for i in (0, 1):
			if pos[i] < 0  or pos[i] >= common.field_size[i]:
				return -1
		return self.field[pos[0]][pos[1]]
		
	def server_call(self, command, *args):
		if self.server:
			self.server.call(command, *args)
	
	def end_test(self):
		alive = filter(lambda player: player.alive, self.players)
		if len(alive) > 1:			
			return
		if len(alive) == 0:
			string = "Draw game!"
		else:
			string = "%s wins!" % alive[0].name
		
		from widget import Button, WidgetState
		class EndState(WidgetState):
			def __init__(self):
				WidgetState.__init__(self)
				Button(string, (None, None), None)
				Button("OK", (None, common.screen.get_height()/2 + 50), self.quit)

			def quit(self):
				WidgetState.quit(self)
				get_game().game_state.quit()
				
		EndState()
		
	def remote_run(self):
		self.run_callback() # usually quits the last state
		common.info("Starting Game")
		self.field.init()
		self.field.draw_backbuffer()
		from config import PlayerConfig
		PlayerConfig.assign()
		from gamephases import AnnouncePhase, SelectPhase, GameState
		self.game_state = GameState()
		self.phase = AnnouncePhase(SelectPhase)
	
	def remote_next_phase(self):
		print "\t-- Next Phase --"
		self.phase.cleanup()
		self.phase.quit()
		self.phase = self.phase.next_phase()
	
	def remote_new_castle(self, pos, player_id):
		from field import Castle
		Castle(pos, self.players[player_id])
	
	def remote_new_house(self, pos):
		from field import Field
		if self.field[pos] == Field.EMPTY:
			for pl in self.players:
				if pl.secured[pos]:
					raise common.ActionNotPossible
			self.field[pos] = Field.HOUSE
			common.backbuffer_blit(Field.obstacle_pic[Field.HOUSE], multiply(pos, common.block_size))
		else:
			raise common.ActionNotPossible
	
	def remote_move_grunt(self, id, new_pos):
		from field import Grunt
		grunt = [g for g in Grunt.instances if g.id == id][0]
		grunt.move(new_pos)
	
	def remote_rotate_grunt(self, id, new_dir):
		from field import Grunt
		grunt = [g for g in Grunt.instances if g.id == id][0]
		grunt.rotate(new_dir)
	
	def remote_hit(self, pos, cannon_id=-1):
		from field import Field, Grunt
		if cannon_id >= 0:
			cannon = [can for can in get_game().cannons if can.id == cannon_id][0]
			cannon.in_use = False
		else:
			# hit was caused by grunt
			cannon = None
		# damage target
		target = get_game().field[pos]
		if target == Field.CANNON:
			for can in get_game().cannons:
				for offset in common.coords((can.size,)*2):
					if list(pos) == list(add(can.pos, offset)):
						can.hit()
		elif target >= 0 or target in (Field.HOUSE, Field.GRUNT):
			# change field
			if not cannon or cannon.type == 0:
				get_game().field[pos] = Field.EMPTY
			else:
				get_game().field[pos] = Field.GARBAGE_NEW
			# recalculate the owner's secured territory if a wall was hit
			if target >= 0:
				player = get_game().players[target]
				get_game().field.look_for_secured_areas(player, pos)
			elif target == Field.GRUNT:
				defeated_grunt = [g for g in Grunt.instances if list(g.pos) == list(pos)][0]
				Grunt.instances.remove(defeated_grunt)
			get_game().field.blit_field(pos)
		else:
			raise common.ActionIrrelevant
		
def get_game():
	return game

