#include "main.h"
#include "errno.h"
#include "string.h"

char Player[10][200];
int Hiscore[10],i;

FILE *OpenOptionsFile( char *mode )
{
    char filename[200];
    FILE *file;
    
    if ((char *)getenv("HOME") != NULL)
	sprintf( filename, "%s/.castle-combat", getenv("HOME"));
    else
	sprintf( filename, "castle-combat.dat");

    file = fopen(filename, mode);
    
    if (file==NULL) {
	fprintf(stderr, "\nWarning: I could not open the options file ");
	if (strcmp(mode, "r") == 0)
	    fprintf(stderr, "for read:");
	else if (strcmp(mode, "w") == 0)
	    fprintf(stderr, "for write:");

	fprintf(stderr, "\n%s\n"
	    "The error that occured was:\n"
	    "%s\n\n", filename, strerror(errno));
    }
    
    return file;
}

void WriteOptions()
{
    FILE *file;

    file=OpenOptionsFile("w");
    if (file==NULL) exit(1);
    
    fprintf(file, "# Castle Combat Options File\n\n");
    for (i=0;i<2;i++) {
	fprintf(file, "%d\n", BPlayer[i].Left);
	fprintf(file, "%d\n", BPlayer[i].Right);
	fprintf(file, "%d\n", BPlayer[i].Up);
	fprintf(file, "%d\n", BPlayer[i].Down);
	fprintf(file, "%d\n", BPlayer[i].Button1);
	fprintf(file, "%d\n", BPlayer[i].Button2);
	fprintf(file, "%s\n", BPlayer[i].Name);
    }
    fprintf(file, "%d\n", PlayerNum);
    fprintf(file, "%s\n", ServerName);
    fprintf(file, "%d\n", LocalPlayerNum);
    fprintf(file, "%d\n", Conquer);

    fclose(file);
}

void ReadOptions()
{
    FILE *file;
        
    // defaults
    BPlayer[0].Left=SDLK_LEFT;
    BPlayer[0].Right=SDLK_RIGHT;
    BPlayer[0].Up=SDLK_UP;
    BPlayer[0].Down=SDLK_DOWN;
    BPlayer[0].Button1=SDLK_RETURN;
    BPlayer[0].Button2=SDLK_RSHIFT;
    strcpy(BPlayer[0].Name,"P1");
    BPlayer[1].Left=SDLK_s;
    BPlayer[1].Right=SDLK_f;
    BPlayer[1].Up=SDLK_e;
    BPlayer[1].Down=SDLK_d;
    BPlayer[1].Button1=SDLK_a;
    BPlayer[1].Button2=SDLK_q;
    strcpy(BPlayer[1].Name,"P2");
    strcpy(ServerName,"10.0.0.1");
    
    // open config file
    file=OpenOptionsFile("r");

    // write config file, if there is none
    if (file==NULL) {	
	WriteOptions();
	return;
    }

    // read data
    fscanf(file, "%*s%*s%*s%*s%*s\n");
    for (i=0;i<2;i++) {
	fscanf(file, "%d\n", &BPlayer[i].Left);
	fscanf(file, "%d\n", &BPlayer[i].Right);
	fscanf(file, "%d\n", &BPlayer[i].Up);
	fscanf(file, "%d\n", &BPlayer[i].Down);
	fscanf(file, "%d\n", &BPlayer[i].Button1);
	fscanf(file, "%d\n", &BPlayer[i].Button2);
	fscanf(file, "%[^\n]\n", BPlayer[i].Name);
    }
    fscanf(file, "%d\n", &PlayerNum);
    fscanf(file, "%[^\n]\n", ServerName);
    fscanf(file, "%d\n", &LocalPlayerNum);
    fscanf(file, "%d\n", &Conquer);
    
    fclose(file);
}
