% Crates.io package policies

In general, these policies are guidelines. Problems are often contextual, and
exceptional circumstances sometimes require exceptional measures. We plan to
continue to clarify and expand these rules over time as new circumstances
arise. If your problem is not described below, consider [sending us an email].

# Package Ownership

We have a first-come, first-served policy on crate names. Upon publishing a
package, the publisher will be made owner of the package on Crates.io.

If someone wants to take over a package, and the previous owner agrees, the
existing maintainer can add them as an owner, and the new maintainer can remove
them. If necessary, the team may reach out to inactive maintainers and help
mediate the process of ownership transfer.

# Removal

Many questions are specialized instances of a more general form: “Under what
circumstances can a package be removed from Crates.io?”

The short version is that packages are first-come, first-served, and we won’t
attempt to get into policing what exactly makes a legitimate package. We will
do what the law requires us to do, and address flagrant violations of the Rust
Code of Conduct.

## Squatting

We do not have any policies to define 'squatting', and so will not hand over
ownership of a package for that reason.


## The Law

For issues such as DMCA violations, trademark and copyright infringement,
Crates.io will respect Mozilla Legal’s decisions with regards to content that
is hosted.

## Code of Conduct

The Rust project has a [Code of Conduct] which governs appropriate conduct for
the Rust community. In general, any content on Crates.io that violates the Code
of Conduct may be removed. There are two important, related aspects:

- We will not be pro-actively monitoring the site for these kinds of violations,
  but relying on the community to draw them to our attention.
- “Does this violate the Code of Conduct” is a contextual question that
  cannot be directly answered in the hypothetical sense. All of the details
  must be taken into consideration in these kinds of situations.

[Code of Conduct]: https://www.rust-lang.org/conduct.html
[sending us an email]: mailto:help@crates.io
