/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_FILEBROWSER_H
#define HAVE_FILEBROWSER_H

#include <iostream>
#include <gtkmm.h>
#include <sys/stat.h>
#include "libs/lib_gtkdirtree.h"
#include "gui_gtkfilelist.h"


class FileBrowser : public Gtk::HPaned {
public:
  FileBrowser();
  ~FileBrowser();
  
  /* Triggered when the filelist selection has changed. */
  SigC::Signal1<void, GList*> signal_filelist_selection_changed;
  
  /* Jump to the given directory. */
  void set_dir(std::string dir);
  
  /* Specify a list of patterns that represent filenames to be shown in the
   * filelist.
   */
  void set_filepattern(const gchar **pfilepattern);
  
  /* Specify a comma-sperated list of patterns that represent filenames to be
   * shown in the filelist.
   */
  void set_filepattern(std::string str);
  
  /* Specify whether or not hidden files and directories should be visible.
   */
  void set_showhidden(gboolean show_hidden);
  
  /* Manually trigger a re-read of the current directory.
   */
  void update(bool hard = TRUE);
  
private:
  void on_dirtree_row_activated(
                            const Gtk::TreeModel::Path& path,
                            Gtk::TreeViewColumn *column);
  void on_dirtree_row_expanded(
                            const Gtk::TreeModel::iterator& iter,
                            const Gtk::TreeModel::Path& path);
  void on_dirtree_row_collapsed(
                            const Gtk::TreeModel::iterator& iter,
                            const Gtk::TreeModel::Path& path);
  void on_dirtree_selection_changed(void);
  void on_filelist_selection_changed(void);
  
  Gtk::TreeView *dirtree_view;
  GtkTreeStore  *dirtree;
  GtkFileList    filelist;
  std::string    curdir;
  const gchar  **filepattern;
  std::string    filepattern_str;
  gboolean       showhidden;
};

#endif
