/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_GUICONTROLLER_H
#define HAVE_GUICONTROLLER_H

#include <iostream>
#include <gtkmm.h>
#include <list>
#include "../controller.h"
#include "gui_mainwindow.h"
#include "gui_preferences.h"


class GUIController : public SigC::Object {
protected:
  // Prevent copys.
  GUIController(GUIController &c) { g_assert_not_reached(); }
  // Prevent assignments.
  GUIController& operator=(GUIController &c) { g_assert_not_reached(); }
  
public:
  GUIController();
  ~GUIController();
  
  void init(void);
  
private:
  void on_preferences_preference_changed(std::string key,
                                         gint type,
                                         void *data);
  void on_menu_file_save_clicked(void);
  void on_menu_edit_preferences_clicked(void);
  void on_preferences_changed(void *key);
  void on_plugin_responsibility_changed(void *data);
  void on_file_rename_finished(void *data);
  void on_filebrowser_selection_changed(GList *selection);
  void on_pluginarea_widget_removed(Plugin *plugin);
  void on_pluginarea1_visibility_changed(gboolean visible);
  void on_pluginarea2_visibility_changed(gboolean visible);
  bool on_progressbar_update_poll(void);
  bool on_filelist_forcerefresh_poll(void);
  bool on_filelist_refresh_poll(void);
  
  PreferencesWindow *preferences;
  bool lock_on_preferences_changed;
  bool have_renamed;      // Whether a file has been renamed in the last period.
};

#endif
