/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "plugin_mpegheader.h"

//#define _DEBUG_

#ifdef _CPLUSPLUS_
extern "C" {
#endif

/******************************************************************************
 * Plugin specifications.
 ******************************************************************************/
#define PLUGINNAME    "MPEG Header Data Display"
#define PLUGINLABEL   _("MPEG-Header")
#define PLUGINDESCR   "Cantus MPEG header plugin 0.1, (c) by Samuel Abels"
#define MAJVERSION    0
#define MINVERSION    1
#define COMPATLEVEL   1
const gchar *pattern[] = {
  "*.mp2",
  "*.mp3",
  NULL
};


/******************************************************************************
 * Plugin-internal variables and types.
 ******************************************************************************/
MpgHeader   header;
CantusHash *plugindata;


/******************************************************************************
 * Plugin constructor/destructor.
 ******************************************************************************/
/* Purpose: Plugin initializer.
 */
gint plugin_init(CantusHash *pplugindata)
{
#ifdef _DEBUG_
  printf("mpegheader(): plugin_init(): Called.\n");
#endif
  plugindata = pplugindata;
  
  cantushash_set_char(plugindata, "Plugin:Name",                PLUGINNAME);
  cantushash_set_char(plugindata, "Plugin:Label",               PLUGINLABEL);
  cantushash_set_char(plugindata, "Plugin:Description",         PLUGINDESCR);
  cantushash_set_int(plugindata,  "Plugin:MajorVersion",        MAJVERSION);
  cantushash_set_int(plugindata,  "Plugin:MinorVersion",        MINVERSION);
  cantushash_set_int(plugindata,  "Plugin:CompatibilityLevel",  COMPATLEVEL);
  cantushash_set_pointer(plugindata, "Plugin:Pattern",          pattern);
  
  return 0;
}


/* Purpose: Plugin destructor.
 */
gint plugin_destroy(void)
{
#ifdef _DEBUG_
  printf("mpegheader(): plugin_destroy(): Called.\n");
#endif
  return 0;
}


/* Purpose: Returns TRUE if the plugin is responsible for handling this
 * filetype, otherwise FALSE.
 */
gboolean plugin_handles(const gchar *filename)
{
#ifdef _DEBUG_
  printf("mpegheader(): plugin_handles(): Called.\n");
#endif
  return TRUE;
}


/******************************************************************************
 * Plugin input/output functions.
 ******************************************************************************/
/* Purpose: Will be called to read a file's information into a hash.
 * Returns an errorcode < 0, or 0.
 */
gint plugin_read(const gchar *filename, CantusHash *info)
{
#ifdef _DEBUG_
  printf("mpegheader(): plugin_read(): Called.\n");
#endif
  
  // Read the header.
  int err = get_mpgheader(&header, filename);
  if (err != 0)
    return err;
#ifdef _DEBUG_
  printf("mpegheader(): read(): Successfully read %s\n", filename);
#endif
  
  // Store the header in the hash.
  cantushash_set_char(info, "MPEGHeader:Version",     header.version);
  cantushash_set_int(info,  "MPEGHeader:Layer",       header.layer);
  cantushash_set_int(info,  "MPEGHeader:Samplerate",  header.frequency);
  cantushash_set_int(info,  "MPEGHeader:Bitrate",     header.bitrate);
  cantushash_set_int(info,  "MPEGHeader:Seconds",     header.seconds);
  cantushash_set_int(info,  "MPEGHeader:Mode",        header.mode);
  
  return 0;
}


/******************************************************************************
 * Plugin GUI functions.
 ******************************************************************************/
/* Returns the widget tree to show as edit-area.
 * NULL as a return value is forbidden!
 * If this function returns NULL, the plugin will be deactivated.
 */
GtkWidget *plugin_get_uiwidget(gboolean vertical)
{
  Displayarea *widget = new Displayarea(plugindata);
  return widget->build();
}

#ifdef _CPLUSPLUS_
}
#endif
