/* The id3v1 library.
 * (c)2002, 2003 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This library is designed for easyest possible access to id3 V1 tags.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#ifndef Tag_def
#define Tag_def
typedef struct Tag_s {
  char title[1024];
  char artist[1024];
  char album[1024];
  char year[5];
  char comment[1024];
  char track[20];
  char genre[512];
  unsigned int size;
  short int has_footer;
} Tag;

typedef struct id3v1Tag_s {
  char title[30];
  char artist[30];
  char album[30];
  char year[4];
  char comment[30];
  unsigned char genre;
} id3v1Tag;
#endif

int get_id3v1_tag(Tag *tag, const char *filename);
int set_id3v1_tag(Tag *tag, const char *filename);
int del_id3v1_tag(const char *filename);
