/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_EDITAREA_H
#define HAVE_EDITAREA_H

#define _CPLUSPLUS_

#include <iostream>
#include <gtkmm.h>
#include <libintl.h>
#include <list>
#include "../gnuhashmap.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

class Editarea : public SigC::Object {
public:
  Editarea();
  ~Editarea();
  
  /* Triggered whenever the save button has been clicked. */
  SigC::Signal0<void> signal_button_save_clicked;
  /* Triggered whenever the copy direction has been changed. */
  SigC::Signal0<void> signal_radio_directionselector_changed;
  
  GtkWidget     *build(gboolean vertical);
  void           set_active(gboolean active);
  
  Gtk::Widget   *get_widget(const gchar *widgetname);
  void           set_label_text(const gchar *widgetname, const gchar *str);
  gboolean       get_check_active(const gchar *widgetname);
  
private:
  std::list<long>  listenerids; // The ids of the eventbus listeners.
                                // A hashtable holding all widgetnames.
  __gnu_cxx::hash_map<std::string, Gtk::Widget*> widgets;
  Gtk::Table      *table;       // The table holding all widgets.
  Gtk::Box        *hvbox;       // The box holding all buttons.
};

#endif
