/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>

#include "support.h"
#include "mp3info.h"
#include "gui_custom_view.h"
#include "custom_find.h"

void clist_custom_view_add_files(GList *filelist)
{
	extern GtkWidget *custom_view;

	GtkCList *clist_custom_view_files = NULL;
	Mp3Info *mp3info = NULL;
	gchar outputrow[10][4096];
	gchar *poutputrow[10];
	gint i = 0;
	
	if(filelist==NULL)
		return;
	
	clist_custom_view_files = GTK_CLIST(lookup_widget(custom_view, "clist_custom_view_files"));
	gtk_clist_freeze(clist_custom_view_files);

	filelist = g_list_first(filelist);
	while(filelist)
	{
		mp3info = (Mp3Info *)filelist->data;
		
		for(i=0; i<=9; i++)
			*outputrow[i] = '\0';
		
		sprintf(outputrow[0], "%s%s", mp3info->directory, mp3info->filename);
		sprintf(outputrow[1], "%luK", mp3info->filesize/1024);
		sprintf(outputrow[2], "%s:%s (%s)", mp3info->owner, mp3info->group, mp3info->mode);
// Artist (i'll use v2 for all fields, if present, otherwise the v1 tag.)
		if(mp3info->v2_artist && *mp3info->v2_artist!='\0')
			sprintf(outputrow[3], "%s", mp3info->v2_artist);
		else
			sprintf(outputrow[3], "%s", mp3info->v1_artist);
// Song
		if(mp3info->v2_title && *mp3info->v2_title!='\0')
			sprintf(outputrow[4], "%s", mp3info->v2_title);
		else
			sprintf(outputrow[4], "%s", mp3info->v1_title);
// Album
		if(mp3info->v2_album && *mp3info->v2_album!='\0')
			sprintf(outputrow[5], "%s", mp3info->v2_album);
		else
			sprintf(outputrow[5], "%s", mp3info->v1_album);
// Track
		if(mp3info->v2_track && *mp3info->v2_track!='\0')
			sprintf(outputrow[6], "%s", mp3info->v2_track);
		else
			sprintf(outputrow[6], "%s", mp3info->v1_track);
// Genre
		sprintf(outputrow[7], "%s", mp3info->v1_genre);
// Year
		if(mp3info->v2_artist && *mp3info->v2_artist!='\0')
			sprintf(outputrow[8], "%s", mp3info->v2_year);
		else
			sprintf(outputrow[8], "%s", mp3info->v1_year);
// Seconds
		if((int)mp3info->seconds-( ((int)mp3info->seconds/60)*60)<10)
			sprintf(outputrow[9], "%i:0%i", (int)mp3info->seconds/60, (int)mp3info->seconds-( ((int)mp3info->seconds/60)*60));
		else
			sprintf(outputrow[9], "%i:%i", (int)mp3info->seconds/60, (int)mp3info->seconds-( ((int)mp3info->seconds/60)*60));

		poutputrow[0] = &outputrow[0][0];
		poutputrow[1] = &outputrow[1][0];
		poutputrow[2] = &outputrow[2][0];
		poutputrow[3] = &outputrow[3][0];
		poutputrow[4] = &outputrow[4][0];
		poutputrow[5] = &outputrow[5][0];
		poutputrow[6] = &outputrow[6][0];
		poutputrow[7] = &outputrow[7][0];
		poutputrow[8] = &outputrow[8][0];
		poutputrow[9] = &outputrow[9][0];
		
		gtk_clist_set_row_data( clist_custom_view_files,
			gtk_clist_append(clist_custom_view_files, poutputrow),
			mp3info );
		
		filelist = filelist->next;
	}
	
	gtk_clist_sort(clist_custom_view_files);
	gtk_clist_columns_autosize(clist_custom_view_files);
	gtk_clist_thaw(clist_custom_view_files);
}


