# -*- coding: utf-8 -*-

#Canto - ncurses RSS reader
#   Copyright (C) 2008 Jack Miller <jack@codezen.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License version 2 as 
#   published by the Free Software Foundation.

import re
import input

class Search(input.Input):
    def __init__(self, cfg, caption, func, register, deregister):
        input.Input.__init__(self, cfg, caption, func, register, deregister)
        
    def callfunc(self):
        if not self.term :
            self.func(None)
            return
        elif self.term.startswith("rgx:"):
            str = self.term[4:]
        else:
            str = ".*" + re.escape(self.term) + ".*"
        
        try:
            m = re.compile(str)
        except:
            self.func(None)

        self.func(m)
