#ifndef AUDIODISPLAYVOLUME_HPP
#define AUDIODISPLAYVOLUME_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qarray.h>
#include <qthread.h>
#include <qvector.h>
#include <qwidget.h>

#include "AudioDevice.h"
#include "LedBar.h"

class CAudioDisplayVolume: public QWidget, public QThread
{
   Q_OBJECT
public:
   /**
     \brief This enum defines the overal display of this widget
   */
   enum DisplayMode
   {
     SkyLine,    ///< All bars are next to eachother, going up
     Stereo,     ///< Horizontal line, with bars progressing from the middle
     Stack,      ///< Horizontal lines, stacked on top of each other; always left to right
   };

private:
   QMutex m_Mutex;
   DisplayMode m_DisplayMode;
   int m_DisplayLength;              ///< vertical or horizontal length
   CAudioRingBufferReader *m_pReader;
   SoundAttributes m_SndAttr;
   int m_Samples;
   bool m_Done;
   QSize m_SizeHint;
   int m_Length;
   int m_MaxShift;

   QVector<CLedBar> m_Bars;
   QArray<int> m_OldMax;
   QArray<int> m_Max;

   void RecalculateSizes();

protected:
   virtual void run();
   virtual void paintEvent(QPaintEvent *ev);
   virtual void resizeEvent(QResizeEvent *ev);

public:
   CAudioDisplayVolume(QWidget *parent = 0, const char *name = 0);
   CAudioDisplayVolume(CAudioRingBufferReader *reader, DisplayMode mode, QWidget *parent = 0, const char *name = 0);
   ~CAudioDisplayVolume();

   void SetMode(DisplayMode mode);
   void SetReader(CAudioRingBufferReader *reader);
   void SetLength(int length);

   virtual QSize sizeHint();
   void Quit(bool Wait = true);

public slots:
   void SetSoundAttributes(const SoundAttributes &);
};

#endif

