#ifndef CODECFRAME_HPP
#define CODECFRAME_HPP

#include <qdict.h>
#include <qlist.h>
#include <qpainter.h>

#include "PanelSelector.h"
#include "CamPanel.h"
#include "CamFrame.h"

class CCodecFrame: public CCamFrame
{
   Q_OBJECT
private:
   QDict<CCamPanel> PanelIdx;
   QList<CCamPanel> PanelList;
   CPanelSelector *pPanels;
   
   void RecalculateSize();

private slots:

protected:
   void drawContents(QPainter *p);
   void mousePressEvent(QMouseEvent *);

   void RegisterPanel(CCamPanel *p);
   void UnregisterPanel(CCamPanel *p, bool Delete = FALSE);
/*   void UnregisterPanel(const char *name); */
   CCamPanel *GetPanel(const char *name) const;

protected slots:
   void TogglePanelsDlg(bool);
   void PanelsDlgClosed();
   void UpdatePanelView();

public:
   CCodecFrame(QWidget *parent = 0, const char *name = 0);
   virtual ~CCodecFrame();

signals:
};   

#endif
