/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2023 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "InteractiveViewerFrame.h"
#include "InteractiveViewer.h"

namespace camitk {

//-------------------- constructor ------------------
InteractiveViewerFrame::InteractiveViewerFrame(QWidget* parent, InteractiveViewer* myInteractiveViewer): QFrame(parent) {
    this->myInteractiveViewer = myInteractiveViewer;
}

//-------------------- keyPressEvent ------------------
void InteractiveViewerFrame::keyPressEvent(QKeyEvent* e) {
    myInteractiveViewer->keyPressEvent(e);
    //-- give the parent a chance!
    QWidget::keyPressEvent(e);
}

//-------------------- showEvent ------------------
void InteractiveViewerFrame::showEvent(QShowEvent*) {
    // now that the widget is visible, refresh
    myInteractiveViewer->refresh();
}


// keep this include here (in the namespace camitk) as long as
// CMake automoc generates a camitk namespace error on this moc
// for the RendererWidget member of the InteractiveViewer class.
// By including it, the file kept out library-camitkcore_automoc.cpp
#include "moc_InteractiveViewer.cpp"

}


