/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef DICOMTREEDIRECTORYCOMPONENT_H
#define DICOMTREEDIRECTORYCOMPONENT_H

// Qt includes
#include <QObject>

// CamiTK include
#include <Component.h>

/**
 *
 * @brief
 * This component allows you to read DICOM images files from a directory.
 *
 * To betterly understand how this component works, here's a little reminder on how DICOM images are organized.
 * For a given PATIENT, we can have several STUDIES. Each STUDY represent a collection of several medical examinations (which can result with images taken from different MODALITIES). A MODALITY is the provider of information, which is, in other words, the machine that allows the doctor to acquire images from the PATIENT. MODALITY are mainly scanners (MRI ...).
 * Each STUDY can have several SERIES of images. One SERIE of images is the result of one medical examination using ONE MODALITY.
 *
 * This component works on images acquired in several SERIES, each of them in a specific STUDY (which can be different).
 * Each SERIE of images represents one 3D volumic image.
 * The public constructor will parse the directory for different STUDIES with different SERIES of images and prompt the user which ones he wants to represent.
 * Each series of images selected is then been rendered in CamiTK's viewers as an ImageComponent.
 * DICOM images tags are also displayed as Property in the PropertyExplorer (DICOM tab).
 *
 * @note
 * Requires GDCM library in order to work correctly.
 * This component does not support 2D Images serie (GDCM limitation)
 */
class DicomTreeDirectoryComponent : public camitk::Component {

    Q_OBJECT

public:
    /**
     * Parse the input directory's images to construct one ImageComponent per 3D volumic image found.
     * @param path: the path to a directory containing several DICOM image files.
     **/
    DicomTreeDirectoryComponent(const QString & path) throw(camitk::AbortException);

    /// Default Destructor
    virtual ~DicomTreeDirectoryComponent();

    /// Empty method, as this Component has no representation
    void initRepresentation() {}

private:

};

#endif // DICOMTREEDIRECTORYCOMPONENT_H

