/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef CEPGENERATOR_H
#define CEPGENERATOR_H

// includes from STL (for Linux) for std::auto_ptr
#include <memory>

// includes from Qt
#include <QDir>
#include <QString>
#include <QFileInfo>
#include <QVector>

// Hide warning for Exception + declspec(nothrow)
#if defined(_WIN32) && !defined(__MINGW32__) // MSVC only
#pragma warning( disable : 4290 )
#endif // MSVC only

// Dependency from cepcoreschema
// Declaration here to avoid declaration in dependant projects.
namespace cepcoreschema {
class Cep;
}

class ExtensionGenerator;

/**
 * @ingroup group_sdk_libraries_cepgenerator
 *
 * @brief
 * TODO Celine comment here please
 *
 **/
class CepGenerator {
public :
    /// Supposes that the CEP does NOT exist
    static bool generateCEP(QString xmlFileName, QString devDirectoryName);
    /// Supposes that the CEP does NOT exist
    static bool generateCEP(std::auto_ptr<cepcoreschema::Cep> domCep, QString devDirectoryName);

protected:
    CepGenerator(QString xmlFilename, QString devDirectoryName);
    CepGenerator(std::auto_ptr<cepcoreschema::Cep> domCep, QString devDirectoryName);

    ~CepGenerator();

    /// Set the input XML CEP manifest (ant check its xml validity)
    virtual void setXmlFileName(QString xmlFileName) throw (QString);
    /// Where to generate the CEP directories and files
    virtual void setDevDirectoryName(QString devDirectoryName) throw (QString);
    /** Create the general directory tree (the same for every CEP)
            Copies the default files in the right directories:

                cepdirectoryname
                    |
                    +--- actions
                        |
                        ---- CMakeLists.txt
                    ----- CMakeLists.txt
                    +--- components
                        |
                        ---- CMakeLists.txt
                    ---- COPYRIGHT
                    ---- FindCamiTK.cmake
                    +--- libraries
                        |
                        --- CMakeLists.txt
                    ---- Manifest.xml
                    ---- README
        */
    virtual void generateDirectoryTree() throw(QString);

    /** @{ Helping Functions  for generateDirectoryTree */
    ///
    virtual void serializeManifest();
    ///
    virtual void generateGlobalCMakeLists();
    ///
    virtual void generateCopyright();
    ///
    virtual void generateReadme();
    ///
    virtual void copyFindCamiTK();
    ///
    virtual void generateActionsDirectory();
    ///
    virtual void generateApplicationsDirectory();
    ///
    virtual void generateComponentsDirectory();
    ///
    virtual void generateLibrariesDirectory();
    ///
    virtual void setLicence();
    /** @} */

    virtual void createActionExtensionDoms();
    virtual void createComponentExtensionDoms();
    virtual void createLibrarieDoms();

    virtual void generateExtensions();

private:

    /// Create the DOM attribute domCep from the XML CEP manifest
    virtual void createDomTree() throw (QString);



    /** XML DOM Element create by CodeSynthesis
            This cep instance contains all of the informations of the xml file
        */
    std::auto_ptr<cepcoreschema::Cep> domCep;

    /// Where to find the original XML description of the CEP
    QFileInfo xmlFileName;

    /// Where to store the produced files
    QDir devDirectoryName;

    /// Subdirectory where the CEP sources will be stored (updated when generating the directory tree)
    QString cepDirectoryName;


    /// Action or Component Extensions
    QVector<ExtensionGenerator *> extensions;

    /// Action Extensions
//    QVector<ActionExtensionGenerator *> actionExtensions;

    /// Component Extensions
//    QVector<ComponentExtensionGenerator *> componentExtensions;

    QString licence;

};

#endif // CEPGENERATOR_H
