/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef CELLPROPERTIES_H
#define CELLPROPERTIES_H

#include "BasicCellProperties.h"

/**
  * This is an automatically generated class for custom Cell properties.
  * It was generated by the <tt>customPhysicalProperties</tt> stylesheet from
  * the following xml document:
  <pre>




  </pre>
  * This class inherits BasicCellProperties.
  * Here is all the specific attributes of Cell properties (custom physical properties).
  */
class CellProperties : public BasicCellProperties {
public:
    /** Constructors (do not change) */
    CellProperties(PhysicalModel *p, const StructureProperties::GeometricType t) : BasicCellProperties(p, t) {
        init();
    };
    CellProperties(PhysicalModel *p, const StructureProperties::GeometricType t ,xmlNodePtr node) : BasicCellProperties(p, t, node) {
        init();
    };
    CellProperties(PhysicalModel *p, const StructureProperties::GeometricType t, const unsigned int ind) : BasicCellProperties(p, t, ind) {
        init();
    };
    virtual ~CellProperties();

    /** Print the properties in xml */
    void xmlPrint(std::ostream &);

    /** Set and get method for all the properties */
    void setMyCustomProperty1(const float);
    float getMyCustomProperty1() const;

    void setMyCustomProperty2(const int);
    int getMyCustomProperty2() const;


protected:

    virtual void init();
    float myCustomProperty1;
    int myCustomProperty2;

};

// inlines
inline void CellProperties::setMyCustomProperty1(const float value) {
    myCustomProperty1 = value;
}
inline float CellProperties::getMyCustomProperty1() const {
    return myCustomProperty1;
}
inline void CellProperties::setMyCustomProperty2(const int value) {
    myCustomProperty2 = value;
}
inline int CellProperties::getMyCustomProperty2() const {
    return myCustomProperty2;
}

#endif

