/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef MultipleComponentDC_H
#define MultipleComponentDC_H

#include <pml/MultiComponent.h>
#include <pml/StructuralComponent.h>
#include "ComponentDC.h"


class MultiComponentDCPopup;
class QPixmap;

class QMenu;

class StructuralComponentDC;

/**The manager of the MultiComponent data.
 * <b>NOTE:</b> a MultipleComponent has no concrete Geometry.
 * 
 */

class PHYSICALMODEL_COMPONENT_API MultiComponentDC : public ComponentDC {
  Q_OBJECT
  public:
    MultiComponentDC(camitk::Component *, PMManagerDC * pmManagerDC,  MultiComponent *);
    virtual ~MultiComponentDC();

    /// Overriden method so that we actually can build a popup menu with different actions
    virtual QMenu * getPopupMenu(QWidget* parent);

    /// convenient method to get the managed mc
    MultiComponent * getMultiComponent();

    /// add a new sub MC and return the corresponding created DC
    MultiComponentDC * addSubMC(MultiComponent *);

    /// add a new sub SC and return the corresponding created DC
    StructuralComponentDC * addSubSC(StructuralComponent *);

    /// add a sub DC: overloaded method to allow change in the physical model data representation
    virtual void addChild(InterfaceNode *);

    /// remove a sub DC: overloaded method to allow change in the physical model data representation
    virtual void removeChild(InterfaceNode *);

    /// get the MultiComponent pixmap
    virtual QPixmap getIcon();

  private:
    /// do nothing as there are no representation!
    void initRepresentation() {};

    /// the popup menu
    MultiComponentDCPopup * myPopupMenu;

    /// the MultiComponentDC pixmap
    static QPixmap * myPixmap;
};


inline MultiComponent * MultiComponentDC::getMultiComponent() {
  return dynamic_cast<MultiComponent *>(myComponent);
}

#endif
