/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

/**
 * @file SphereTopology.h
 * @brief Class for 3D sphere mesh creation
 * @author Mathieu BAILET
 * @date July 5 2012
 */

#ifndef SPHERE_TOPOLOGY_HPP_
#define SPHERE_TOPOLOGY_HPP_

#include <Action.h>

using namespace camitk;

/**
 * @class SphereTopology
 * @brief Create a sphere mesh.
 */
class SphereTopology : public Action {

public:
  
    /// the constructor
    SphereTopology(ActionExtension *);

    /// the destructor
    virtual ~SphereTopology();

    /// method called when the action when the action is triggered (i.e. started)
    //virtual QWidget * getWidget();
    
private:
  
    /// method called when the action is applied
    virtual ApplyStatus apply();

    QWidget* myWidget;
    
};

#endif // SPHERE_TOPOLOGY_HPP_