#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

object parser = camas_tags->cache_parse_html();

// ============================================================================
//  ATTACHMENTS screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "";
  CSESSION->screen = "attachments";       // Admin screen name

  // TODO: some widget hasn't been ported from old IMHO
  //       especially in the case when uploaddir was true

  contents = parser->run(contents,
                        ([
                         "camas_attachmentlist"           : tag_camas_attachments,
                         "camas_removemarkedattachments"  : tag_camas_attachments,
			 "camas_removemarkedattachments2"  : tag_camas_attachments,
                         "camas_continuecompose"          : tag_camas_attachments,
                         ]),
                        ([
                         "camas_uploadfiles"             	: container_camas_uploadfiles,
                         "camas_attachments"            	: container_camas_attachments,
                         ]),
                        CSESSION->layout, __FILE__ + "/" + hash(contents), id);

  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);

  args->method = "post";
  args->name = "camasattachmentsform";

  args = CAMAS.Tools.set_target(id, args);

  out += CAMAS.Tools.make_container("form", args, contents);

  return out;
}

//! container: camas_uploadfiles
//!  Zone for dealing with files to upload
//! childtag : filepath
//! childtag : addthisfile
string container_camas_uploadfiles(string tag_name, int pos, mapping args, string contents,object id)
{
  string out = "";

  out += "</form>";

  args -> method = "post";
  args -> action = id->misc->camas->nextpage;
  args -> target = id->misc->camas->target;
  args -> name   = "imhouploadform";
  args -> enctype= "multipart/form-data";

  contents = parser->run(contents,
                    ([
                     "camas_filepath"                       : tag_camas_uploadfiles_subtags,
                     "camas_addthisfile"                    : tag_camas_uploadfiles_subtags,
                     ]),
                    ([
                     ]),
                    CSESSION->layout, __FILE__ + "/" + pos, id);
  out += CAMAS.Tools.make_container("form", args, contents);

  out += "<form target=\"" + id->misc->camas->target;
  out += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";

  return out;
}


/* code for tags included in the camas_uploadfiles container */
string tag_camas_uploadfiles_subtags(string tag_name, int pos, mapping args, object id)
{
  string out = "";

  switch(tag_name)
  {
    case "camas_filepath":
      //! tag: camas_filepath
      //! parentcontainer : camas_uploadfiles
      //!  Path of the file to add to attachments
      //! note: screen: attachments
      args->name = "file";
      args->type = "file";
      out += CAMAS.Tools.make_tag("input", args) + "\n";
      break;

    case "camas_addthisfile":
      //! tag: camas_addthisfile
      //! parentcontainer : camas_uploadfiles
      //!  Button for adding all selected item to attachments list
      //! note: screen: attachments
			mapping hiddenargs = ([ ]);
	    hiddenargs->type = "hidden";

      if (id->supports->javascript)
      {
	      hiddenargs->name = "fixedfilename";
	      hiddenargs->value= "";
	      out += CAMAS.Tools.make_tag ("input", hiddenargs);
      }
      else
      {
	      out += MSG(M_WINDOWSBUG);
      }

      hiddenargs->name = "actionuploadattachment";
      hiddenargs->value= "1";

      out += CAMAS.Tools.make_tag ("input", hiddenargs) + "\n";

			// Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'
			// TODO: is that still a common bug?
			args->onclick = "document.forms.camasuploadform.fixedfilename.value=document.forms.camasuploadform.file.value.replace(/\\\\/g,'\\\\\\\\')";

			out += CAMAS.Tools.formdrawbutton(id,"m_uploadtoattachments", "1", MSG(M_UPLOADTOATTACHMENTS), args);

      break;
    
    default:
      out += "<!-- container_uploadfiles_subtags: " + tag_name + " is not supported yet -->";
      CDEBUG("<!-- container_uploadfiles_subtags: " + tag_name + " is not supported yet -->");
  }
  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
