/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: IMHOTools.pmod,v 1.6 2004/01/13 11:01:37 vida Exp $
 */

//! file: IMHOTools.pmod
//!  IMHO compatibility tools for CAMAS
//! cvs_version: $Id: IMHOTools.pmod,v 1.6 2004/01/13 11:01:37 vida Exp $

#include <camas/globals.h>

//! method: int find_mailbox (object sessobj, string name)
//!  returns the index of a given mailbox name
//!
//! NOTE: this is only used in camas_imho.pike:
//!   tag_imho_url, cont_imho_href
//!   maybe we can remove this ? --oliv3
//! 
//! returns:
//!  an int, the index
//! arg: mapping sessobj
//!  The session
//! arg: string name
//!  The mailbox to find
int find_mailbox (object sessobj, string name) {	
  int nr = Array.search_array (sessobj->mailboxes,
			       lambda (array a, string mbox) {
				 return (a[MB_DISPLAYNAME_IDX] == mbox) ? 1 : 0;
			       },
			       name);
  return nr;
}
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

