/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: LDIF.pmod,v 1.4 2004/01/13 11:01:38 vida Exp $
 */

#include <camas/addressbook.h>

//! file: LDIF.pmod
//!   LDIF (Mozilla, Netscape, etc...) address book handler for Camas
//! cvs_version: $Id: LDIF.pmod,v 1.4 2004/01/13 11:01:38 vida Exp $

//! method: int|array(array(string)) imp(string adds) 
//!  Return the address book from ldif format handler
array(mapping(int:string)) imp(string adds)
{
  array(mapping(int:string)) result;
  adds = replace(adds, "\r", "");
  array(string) lines = adds / "\n";
  mapping(int:string) contact = ([ ]);
  foreach(lines, string line)
  {
    // it can't be a ldif entry if the size of the line is less than 2
    if(sizeof(line) < 2)
      continue;
    array(string) attribute = allocate(2);
    int pos = search(line, ":");
    attribute[0] = line[0..pos-1];
    if(line[pos+1] == ':')
    {
      // it's base64 encoded
      attribute[1] = MIME.decode_base64(line[pos+3..]);
    }
    else
      attribute[1] = line[pos+2..];
    if(attribute[0] == "dn")
    {
      if(!result)
        result = ({ });
      else
        result += ({ contact });
      contact = ([ ]);
    }
    int internal_attr = ldapattributes2input[attribute[0]];
    if(internal_attr)
      contact += ([ internal_attr: attribute[1] ]);
  }
  result += ({ contact });
  return result;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

