import re

from calibre.web.feeds.news import BasicNewsRecipe

class Winsupersite(BasicNewsRecipe):
    title          = u'Supersite for Windows'
    description           = u'Paul Thurrott SuperSite for Windows'
    publisher             = 'Paul Thurrott'
    __author__            = 'Hypernova'
    language              = _('English')
    oldest_article = 30
    max_articles_per_feed = 100
    no_stylesheets        = True
    use_embedded_content  = False
    remove_javascript     = True
    html2lrf_options = ['--ignore-tables']
    html2epub_options = 'linearize_tables = True'
    remove_tags_before = dict(name='h1')
    preprocess_regexps = [
   (re.compile(r'<p>--Paul Thurrott.*</body>', re.DOTALL|re.IGNORECASE),
    lambda match: '</body>'),
]
    def get_browser(self):
        br = BasicNewsRecipe.get_browser()
        br.open('http://www.winsupersite.com')
        return br
    
    feeds          = [(u'Supersite for Windows', u'http://www.winsupersite.com/supersite.xml')]
