/*
 * Calcurse - text-based organizer
 * Copyright (c) 2004-2005 Frederic Culot
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Send your feedback or comments to : calcurse@culot.org
 * Calcurse home page : http://culot.org/calcurse
 *
 */

#include <ncurses.h>
#include <panel.h>

#include "custom.h"
#include "vars.h"



  /* Draws the configuration bar */
void config_bar(int colr)
{
	int smlspc, spc;

	smlspc = 2;
	spc = 15;

	attron(COLOR_PAIR(colr));
	mvprintw(row - 2, 0, "Q");
	mvprintw(row - 1, 0, "G");
	mvprintw(row - 2, spc, "L");
	mvprintw(row - 1, spc, "C");
	attroff(COLOR_PAIR(colr));
	refresh();

	mvprintw(row - 2, smlspc, "Exit");
	mvprintw(row - 1, smlspc, "General");
	mvprintw(row - 2, spc + smlspc, "Layout");
	mvprintw(row - 1, spc + smlspc, "Color");

	refresh();
	doupdate();
}

/* Choose the layout */
int layout_config(int layout, int colr)
{
	int ch, old_layout;

	old_layout = layout;
	erase_status_bar();
	attron(COLOR_PAIR(colr));
	mvprintw(row - 2, 0,
		 "Pick the desired layout on next screen [press ENTER]");
	mvprintw(row - 1, 0,
		 "('A'= Appointment panel, 'c'= calendar panel, 't'= todo panel, 'q' to quit)");
	attroff(COLOR_PAIR(colr));
	getch();
	erase_status_bar();
	attron(COLOR_PAIR(colr));
	mvprintw(row - 2, 0, "   |Ac|      |At|      |cA|      |tA|");
	mvprintw(row - 1, 0, "[1]|At|   [2]|Ac|   [3]|tA|   [4]|cA|");
	attroff(COLOR_PAIR(colr));
	refresh();
	doupdate();
	while ((ch = getch()) != 'q') {
		switch (ch) {
		case '1':
			layout = 1;
			return layout;
		case '2':
			layout = 2;
			return layout;
		case '3':
			layout = 3;
			return layout;
		case '4':
			layout = 4;
			return layout;
		}
	}
	layout = old_layout;
	return layout;
}

/* Choose the color theme */
int color_config(int colr)
{
	int i, ch, old_colr;

	old_colr = colr;
	erase_status_bar();
	for (i = 1; i < 9; i++) {
		attron(COLOR_PAIR(i));
		mvprintw(row - 1, (i - 1) * 6, "[>%d<]", i);
		attroff(COLOR_PAIR(i));
	}
	attron(COLOR_PAIR(colr));
	mvprintw(row - 2, 0,
		 "Pick the number corresponding to the color scheme "
		 "(Q to exit) :");
	attroff(COLOR_PAIR(colr));
	refresh();
	doupdate();
	while ((ch = getch()) != 'q') {
		switch (ch) {
		case '1':
			colr = 1;
			return colr;
		case '2':
			colr = 2;
			return colr;
		case '3':
			colr = 3;
			return colr;
		case '4':
			colr = 4;
			return colr;
		case '5':
			colr = 5;
			return colr;
		case '6':
			colr = 6;
			return colr;
		case '7':
			colr = 7;
			return colr;
		case '8':
			colr = 8;
			return colr;
		case '9':
			colr = 9;
			return colr;
		}
	}
	colr = old_colr;
	return colr;
}
