/* cacao/cacao.h - main header, contains global variables

   Copyright (C) 1996-2005 R. Grafl, A. Krall, C. Kruegel, C. Oates,
   R. Obermaisser, M. Platter, M. Probst, S. Ring, E. Steiner,
   C. Thalinger, D. Thuernbeck, P. Tomsich, C. Ullrich, J. Wenninger,
   Institut f. Computersprachen - TU Wien

   This file is part of CACAO.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

   Contact: cacao@complang.tuwien.ac.at

   Authors: Christian Thalinger

   $Id: cacao.h,v 1.17 2005/10/06 13:12:45 twisti Exp $

*/


#ifndef _CACAO_H
#define _CACAO_H

#include "native/jni.h"
#include "vm/global.h"


/* global variables ***********************************************************/

extern u1 *intrp_main_stack;

extern bool cacao_exiting;

extern JavaVM *jvm;
extern JNIEnv *env;

extern char *bootclasspath;
extern char *classpath;

extern char *mainstring;    /* class.method with main method */


/* function prototypes ********************************************************/

void cacao_exit(s4 status);
void cacao_shutdown(s4 status);

#endif /* _CACAO_H */


/*
 * These are local overrides for various environment variables in Emacs.
 * Please do not remove this and leave it at the end of the file, where
 * Emacs will automagically detect them.
 * ---------------------------------------------------------------------
 * Local variables:
 * mode: c
 * indent-tabs-mode: t
 * c-basic-offset: 4
 * tab-width: 4
 * End:
 */
