#!/usr/bin/env python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Rick Spencer rick.spencer@canonical.com
#This program is free software: you can redistribute it and/or modify it 
#under the terms of the GNU General Public License version 3, as published 
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but 
#WITHOUT ANY WARRANTY; without even the implied warranties of 
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along 
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import pygtk
pygtk.require('2.0')
import glib
import gtk
import os
import gobject
from quickly.widgets.asynch_task_progressbox import AsynchTaskProgressBox
import LaunchpadUtils
from launchpadlib.credentials import Credentials
import webbrowser
from launchpadlib.launchpad import Launchpad, EDGE_SERVICE_ROOT, STAGING_SERVICE_ROOT
from launchpadlib.credentials import Credentials
from lazr.uri import URI

from bughugger.bughuggerconfig import getdatapath

class LaunchpadLogonDialog():
 def __init__(self,appname,use_production):
  print "running logon dialog for " + appname

  self.use_production = use_production
  self.app_name = appname
  self.credentials = Credentials(self.app_name)

  self.builder = gtk.Builder()
  ui_filename = os.path.join(getdatapath(), 'ui', 'LaunchpadLogonDialog.ui')
  self.builder.add_from_file(ui_filename)
  self.dialog = self.builder.get_object("dialog")
  self.builder.connect_signals(self)

  params = {"app_name":self.app_name}
  su = AsynchTaskProgressBox(self.mkdirs_task, params, False)
  su.show()
  self.builder.get_object("progress_box").pack_start(su)
  su.connect("complete",self.mkdirs_complete)
  su.start()  

 #Following are the functions needed to make this look like a
 #gtk.Dialog to callers

 def connect(self, signal, func):
  self.dialog.connect(signal,func)

 def show(self):
  self.dialog.show()

 def hide(self):
  self.dialog.hide()

 def run(self):
  self.dialog.run()

 def response(response_type):
  self.dialog.response(response_type)

 def mkdirs_task(self, params):
  print "making .local directory for " + self.app_name
  self.setup_app_directories()
  
  if self.previously_authorized():
   cached_lp = self.get_cached_launchpad()
   return cached_lp
  else:
   return None
 
 def get_cached_launchpad(self):
  """get_cached_launchpad: re-instantiates a cached launchpad instance.
  Assumes there is a saved credentials file in app directory and
  a saved Launchpad instance in the cache directory. 

  arguments:
  app_name --- the string for the name of the application
  cache_dir -- the cache directory.
  """
  print "credentials file exists. Using it"
  self.credentials = Credentials()
  credentials_file = os.path.join(self.app_dir, "credentials")
  self.credentials.load(open(credentials_file))
  return self.launchpad_from_credentials()

 def previously_authorized(self):
  """previously_authorized: checks if tehre is a credentials file cacheed at
  ~/.local/share/app_name/credentials.
 
  aguments:
  app_name --- the string for the name of the application 
 
  """
  credentials_file = os.path.join(self.app_dir, "credentials")
  print credentials_file
  return os.path.exists(credentials_file)

 def setup_app_directories(self):
  """get_app_directories: function to create a directory at
  ~/.local/share/app_name. It will also create a .cache directory there
  for storing Launchpad cache.

  arguments:
  app_name: the string representing the name of the application. Also used
  to name the directory in the .local directory.

  returns a two tuple with the app directory and the cache directory.
  """
  cache_dir = os.path.join(glib.get_user_cache_dir(), self.app_name)
  app_dir = os.path.join(glib.get_user_data_dir(), self.app_name)
  prod_dir = os.path.join(app_dir, "production")
  stag_dir = os.path.join(app_dir, "staging")
  prod_cache_dir = os.path.join(cache_dir, "production")
  stag_cache_dir = os.path.join(cache_dir, "staging")
  
  if not os.path.exists(app_dir):
   os.makedirs(app_dir)

  if not os.path.exists(prod_dir):
    os.makedirs(prod_dir)

  if not os.path.exists(stag_dir):
   os.makedirs(stag_dir)

  if not os.path.exists(cache_dir):
    os.makedirs(cache_dir)
 
  if not os.path.exists(prod_cache_dir):
   os.makedirs(prod_cache_dir)

  if not os.path.exists(stag_cache_dir):
   os.makedirs(stag_cache_dir)

  else:
   print "cache directory at " + cache_dir

  if self.use_production:
   self.app_dir = prod_dir
   self.cache_dir = prod_cache_dir
  else:
   self.app_dir = stag_dir
   self.cache_dir = stag_cache_dir

 def mkdirs_complete(self, widget, data = None):
  print "directories now exist for " + self.app_name
  self.builder.get_object("progress_box").remove(widget)

  if data != None: #there were cached credentials
   print "using cached credentials"
   self.launchpad = data
   self.dialog.response(gtk.RESPONSE_ACCEPT)

  else:
   print "no cached credentials, retrieving from Launchpad"
   self.get_auth_progress_box = AsynchTaskProgressBox(self.get_auth_task, None, False)
   self.get_auth_progress_box.connect("complete",self.auth_url_received)
   self.get_auth_progress_box.show()
   self.builder.get_object("progress_box").pack_start(self.get_auth_progress_box)
   gtk.gdk.threads_enter()
   self.get_auth_progress_box.start("Requesting Authorization Token from Launchpad")
   gtk.gdk.threads_leave()

 def web_root(self):
  """web_root: get the URL to use while making calls to the server.
  Used with python-launchpad lib, typically as 'web-root'.

  """
  #use EDGE_SERVICE_ROOT for live data
  if not self.use_production:
   return STAGING_SERVICE_ROOT #using the staging server while developing
  else:
   return EDGE_SERVICE_ROOT # using the live server

 def __get_auth_url(self, credentials, use_production=False):
  """get_auth_url:  returns a string that is a url where the user can grant
  the client authorization on the server.

  arguments:
  credentials: an instantiated credentials object that has a request token

  """
  web_root_uri = URI(self.web_root())
  web_root_uri.path = ""
  web_root_uri.host = web_root_uri.host.replace("api.", "", 1)
  web_root2 = str(web_root_uri.ensureSlash())
  print "contacting " + web_root2 + " to get auth url for credentials:"
  print credentials
  auth_url = credentials.get_request_token(web_root=web_root2)
  print "received auth_url: " + auth_url
  return auth_url

 def get_auth_task(self,params):
  print "attempting to authenticate"
  link = self.__get_auth_url(self.credentials, self.use_production)
  print "auth link received " + link
  return link

 def auth_url_received(self,widget,data):
  print "authentication url received"
  self.builder.get_object("scene_1").hide()
  self.builder.get_object("scene_2").show()
  self.builder.get_object("launchpad_link_button").set_uri(data)
  self.builder.get_object("progress_box").remove(widget)

 def launchpad_clicked(self,widget,data = None):
  self.builder.get_object("scene_2").hide()
  self.builder.get_object("scene_3").show()

 def exchange_credentials(self):
  """exchange_credentials: negotiates credentials between the client and server.

  arguments:
  credentials -- an instantiated credentials object

  """
  web_root_uri = URI(self.web_root())
  web_root_uri.path = ""
  web_root_uri.host = web_root_uri.host.replace("api.", "", 1)
  web_root2 = str(web_root_uri.ensureSlash())
  self.credentials.exchange_request_token_for_access_token(web_root2)

 def launchpad_from_credentials(self):
  """launchpad_from_credentials: returns a re-instantiated Launchpad instance
  form the supllied credentials and Launchpad cache directory. 

  arguments:
  app_name --- the string for the name of the application
  credentials -- launchpad credentials object
  cache_dir -- the cache directory.
 
  """

  credentials_file = os.path.join(self.app_dir, "credentials")
  launchpad = Launchpad(self.credentials, self.web_root(), self.cache_dir)
  launchpad.credentials.save(file(credentials_file, "w"))
  os.chmod(credentials_file, 0600)
  return launchpad

 def ack_launchpad(self,widget,data = None):
  print "user has granted authentication, please wait for handshake"
  #TODO: put this on a thread, can take a long time, specially on staging

  self.exchange_credentials()
  try:
   self.launchpad = self.launchpad_from_credentials()
  except Exception, inst:
   print inst
   self.dialog.response(gtk.RESPONSE_REJECT)
  self.dialog.response(gtk.RESPONSE_ACCEPT)

 def nack_launchpad(self,widget, data = None):
  self.dialog.response(gtk.RESPONSE_REJECT)

