import re

class bughelper(object):
    def header(self,content):
        return "<html><body>"
    
    def footer(self,content={}):
        text = ""
        if content.has_key("statistic"):
            text += "<div>"
            text += "<b>Summary</b>\n"
            text += "<ul>\n"
            text += "<li>Total: %i</li>\n" %content["statistic"]["total"]
            for key in ["status","importance"]:
                text += "<li>%s</li>\n" %key
                text += "<ul>\n"
                for k in content["statistic"][key]:
                    text += "<li>%s: %s</li>\n"%(k,content["statistic"][key][k])
                text += "</ul>\n"
            text += "</ul>"
            text += "</div>"
        if content.has_key("time"):
            text += "<div>"
            text += "<small>last modified: %s in %s seconds</small>" %(content["time"]["time"],content["time"]["duration"])
            text += "</div>"
        if text:
            text = "<div>\n%s\n</div>" %text
        return "%s</html></body>" %text
            
    def info(self):
        pass
    
    def data(self, content):
        bug = content["bug"]
        displayclues = content["clue"]
        text = "<div>"
        if displayclues:
            text += "<ul>"
            for key in displayclues.keys():
                text += "<li>%s</li>" % key
                attachments_string = ""
                if displayclues[key]:
                    attachments_string += "<ul>%s</ul>" % \
                            "".join(["<li><a href='%s'>%s</a></li>" % \
                                    (a, a) for a in displayclues[key]])
                if attachments_string:
                    text += attachments_string
            text += "</ul>"
        display = """Bug %s - %s
%s</div>""" % (bug.bugnumber, bug.info, text)
        return re.sub(r'[Bb]ug #?([0-9]+)', r'<a href="http://launchpad.net/bugs/\1">Bug #\1</a>', display)
        
class bugnumbers(object):
    def header(self,content):
        return "<html><body><table>"
    
    def footer(self,content={}):
        text = ""
        if content.has_key("statistic"):
            text += "<div>"
            text += "<b>Summary</b>\n"
            text += "<ul>\n"
            text += "<li>Total: %i</li>\n" %content["statistic"]["total"]
            for key in ["status","importance"]:
                text += "<li>%s</li>\n" %key
                text += "<ul>\n"
                for k in content["statistic"][key]:
                    text += "<li>%s: %s</li>\n"%(k,content["statistic"][key][k])
                text += "</ul>\n"
            text += "</ul>"
            text += "</div>"
        if content.has_key("time"):
            text += "<div>"
            text += "<small>last modified: %s in %s seconds</small>" %(content["time"]["time"],content["time"]["duration"])
            text += "</div>"
        if text:
            text = "<div>\n%s\n</div>" %text
        return "</table><br>%s</html></body>" %text
            
    def info(self):
        pass
        
    def data(self,content):
        bug = content["bug"]
        return """<tr>
    <td><a href="http://launchpad.net/bugs/%i">Bug %i</a></td>
    <td>(%s,%s)</td>
    <td>%s</td>
</tr>""" %(bug,bug,bug.status,bug.importance,bug.summary)
