# Coding standards
----
Following conventions should be followed while contributing to `budgie-welcome` project.
- Use 4 spaces for indentation of code
- Limit all lines to a maximum of 79 characters. 
- Lines should be broken before binary operators as it gives better readability.
-  Surround top-level function and class definitions with two blank lines.
-  Method definitions inside a class are surrounded by a single blank line. 
- Simple import statements should be written in separate lines.
- Avoid trailing whitespace anywhere.
- Always surround binary operators with a single space on either side
- Don't use spaces around the = sign when used to indicate a keyword argument or a default parameter value. 
- Comments should be complete sentences. If a comment is a phrase or sentence, its first word should be capitalized, unless it is an identifier that begins with a lower case letter

**This document is incomplete. More conventions should be mentioned to  make things consistent throughout the project.**

All these conventions are adopted from [PEP 8 - Style Guide for Python Code)(https://www.python.org/dev/peps/pep-0008/)
