/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

public class LockKeysPlugin : Budgie.Plugin, Peas.ExtensionBase
{
    public Budgie.Applet get_panel_widget(string uuid)
    {
        return new LockKeysApplet();
    }
}

public class LockKeysApplet : Budgie.Applet
{

    Gtk.Box widget;
    Gtk.Image caps;
    Gtk.Image num;
    new Gdk.Keymap map;

    public LockKeysApplet()
    {
        widget = new Gtk.Box(Gtk.Orientation.HORIZONTAL, 2);
        add(widget);

        get_style_context().add_class("lock-keys");
        /* Pretty labels, probably use icons in future */
        caps = new Gtk.Image.from_icon_name("format-text-bold-symbolic", Gtk.IconSize.MENU);
        num = new Gtk.Image.from_icon_name("zoom-original-symbolic", Gtk.IconSize.MENU);
        widget.pack_start(caps, false, false, 0);
        widget.pack_start(num, false, false, 0);

        map = Gdk.Keymap.get_default();
        map.state_changed.connect(on_state_changed);

        on_state_changed();

        show_all();
    }

    /* Handle caps lock changes */
    protected void toggle_caps()
    {
        caps.set_sensitive(map.get_caps_lock_state());
        if (map.get_caps_lock_state()) {
            caps.set_tooltip_text(_("Caps lock is active"));
            caps.get_style_context().remove_class("dim-label");
        } else {
            caps.set_tooltip_text(_("Caps lock is not active"));
            caps.get_style_context().add_class("dim-label");
        }
    }

    /* Handle num lock changes */
    protected void toggle_num()
    {
        num.set_sensitive(map.get_num_lock_state());
        if (map.get_num_lock_state()) {
            num.set_tooltip_text(_("Num lock is active"));
            num.get_style_context().remove_class("dim-label");
        } else {
            num.set_tooltip_text(_("Num lock is not active"));
            num.get_style_context().add_class("dim-label");
        }
    }

    protected void on_state_changed()
    {
        toggle_caps();
        toggle_num();
    }
}


[ModuleInit]
public void peas_register_types(TypeModule module)
{
    // boilerplate - all modules need this
    var objmodule = module as Peas.ObjectModule;
    objmodule.register_extension_type(typeof(Budgie.Plugin), typeof(LockKeysPlugin));
}

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=4 tabstop=4 expandtab:
 * :indentSize=4:tabSize=4:noTabs=true:
 */
