/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *-------------------------------------------------------------------
 * These algorithms are from book:
 * John Viega and Matt Messier - "Secure Programming Cookbook for C and C++"
 *******************************************************************/
#ifndef INCLUDED_WIPEFILE_H
#define INCLUDED_WIPEFILE_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QOBJECT_H
#include <qobject.h>
#define INCLUDED_QOBJECT_H
#endif // INCLUDED_QOBJECT_H

#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_UNISTD_H
#include <unistd.h>
#define INCLUDED_UNISTD_H
#endif // INCLUDED_UNISTD_H

/*------- class declaration:
-------------------------------------------------------------------*/
class WipeFile : public QObject
{
    Q_OBJECT

// ******* CONSTRUCTION / DESTRUCTION *******
public:
    WipeFile( const QString& in_fpath, QDialog* in_dialog = 0 );
private:
    WipeFile( const WipeFile& );
    WipeFile& operator=( const WipeFile& );

// ******* TYPES *******
private:
    enum {
        WIPE_BUFSIZE = 4096,
        SINGLE_PATS_SIZE = 16,
        TRIPLE_PATS_ROWS = 6,
        TRIPLE_PATS_COLS = 3
    };

// ******* CONSTANTS *******
private:
    static const unsigned char SinglePats[SINGLE_PATS_SIZE];
    static const unsigned char TriplePats[TRIPLE_PATS_ROWS][TRIPLE_PATS_COLS];
    static const QString       WipeMsg;

// ******* MEMBERS *******
private:
    const QString  d_fpath;
    QDialog* const d_dialog;
    int            d_devrand_fd;
    int            d_devrand_fd_noblock;
    int            d_devurand_fd;
    unsigned char  d_buffer[WIPE_BUFSIZE];

// ******* METHODS *******
public:
	int wipe               ();
private:
	int  fd_wipe           ( int in_fd );
	int  pattern_pass      ( int in_fd, unsigned char* in_buffer, size_t in_bufsize, size_t in_filesize );
	int  random_pass       ( int in_fd, size_t in_nbytes );
    int  write_data        ( int in_fd, const void* const in_buffer, size_t in_nbytes );
    int  make_fd_noblocking( int in_fd );
    int  rand_init         ();
    int  rand              ( unsigned char* out_buffer, size_t in_nbytes );
    void progress          ( int in_progress );
    bool can_do            ();
};

#endif // INCLUDED_WIPEFILE_H
