/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_VIEWTABLE_H
#define INCLUDED_VIEWTABLE_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_VIEWTABLEINFO_H
#include "ViewTableItem.h"
#endif // INCLUDED_VIEWTABLEINFO_H

#ifndef INCLUDED_QLISTVIEW_H
#include <qlistview.h>
#define INCLUDED_QLISTVIEW_H
#endif // INCLUDED_QLISTVIEW_H

#ifndef INCLUDED_QTIMER_H
#include <qtimer.h>
#define INCLUDED_QTIMER_H
#endif // INCLUDED_QTIMER_H

#ifndef INCLUDED_QPIXMAP_H
#include <qpixmap.h>
#define INCLUDED_QPIXMAP_H
#endif // INCLUDED_QPIXMAP_H

#include <qstring.h>

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

/*------- class declaration:
-------------------------------------------------------------------*/
class ViewTable : public QListView
{
	Q_OBJECT

// ******* TYPES *******
public:
	typedef std::vector<ViewTableItem*> SelectedItems;
private:
	typedef enum {
		COL_FNAME = 0,
		COL_FEXT,		
		COL_ACCESS,
		COL_SIZE,
		COL_DATE,
		COL_TIME,
		COL_OWNER,
		COL_GROUP,
		COLUMNS
	};
	//typedef KDE_SELMODE Extended;
//	typedef NoSelection NC_SELMODE
	
//	typedef enum {
//		KDE_SELMODE = Extended,
//		NC_SELMODE  = NoSelection
//	};

	typedef struct {
		QString name;
		Qt::AlignmentFlags align;
	} ColumnDef;

	struct ItemAsText {
		QString info[ COLUMNS ];
		ItemAsText () {
			clear();
		}
		void clear() {
			for( int i = 0; i < COLUMNS; ++i ) {
				info[i] = "";
			}
		}
	};

// ******* CONSTRUCTION *******
public:
	ViewTable( QWidget* const in_parent );
private:
	ViewTable( const ViewTable& );
	ViewTable& operator=( const ViewTable& );
	
// ******* CONSTANTS *******
private:
	static const ColumnDef  COLDEF[ COLUMNS ];
	static const QString    FILE_SELECTION_CAPTION;
	static const QString    FILE_SELECTION_PROMPT;
	static const QString    FILE_DESELECTION_CAPTION;
	static const QString    FILE_DESELECTION_PROMPT;
	static const QColor     CTXMENU_BACKGROUND_COLOR;
	static const QString    FOLDER_ICON;
	static const QString    IFOLDER_ICON;
	static const QString    DRAG_DROP_ICON;
	static const QString    DRAG_DROP_SUBTYPE;
	static const QString    DRAG_DROP_CMD;
	
// ******* MEMBERS *******
private:
	QTimer        d_timer;
	QPoint        d_drag_pos;
	ItemAsText    d_item_as_text;
	int           d_sel_counter;
	QString       d_fname_on_start;
	SelectedItems d_selections;
	SelectionMode d_selection_mode;

// ******* METHODS *******
public:
	SelectionMode  selection_mode() const { return d_selection_mode; }
	ViewTableItem* current_item () const;
	void adjust                 ();
	void reset                  ();
	void add_new_item           ( const QFileInfo&, bool );
	void add_new_item           ( const QUrlInfo&, bool );
	void get_fname_fext         ( const ViewTableItem*, QString&, QString& );
	bool get_current_info       ( QString&, bool& );
	void get_current_fname_fext ( QString&, QString& );
	void get_fname              ( const ViewTableItem*, QString& );
	void get_current_fname      ( QString& );
	void select_item_after_start();
	// OPERACJE ZWIAZANE Z ZAZNACZANIEM
	void select_by_name         ( const QString&, const QString& );
	void select_by_name         ( const QString& );
	void select_first_item      ();
	void select_dir_by_name     ( const QString& );
	void select_plus            ();
	void select_minus           ();
	const SelectedItems& selections();
	void set_fname_on_start     ( const QString& );
	int  get_selections_number  ();
	void check_parent_mark      ();
	void set_dir_size           ( ViewTableItem* const, const Q_ULLONG );
	void retranslate_strings    ();
private:
	void select_this_one        ();
	void keyPressEvent          ( QKeyEvent* );
	void showEvent              ( QShowEvent* );
	void rightButtonClicked     ( ViewTableItem*, const QPoint&, int );
	void setSorting             ( int, bool );
	// OBSLUGA ZDARZEN ZWIAZANYCH Z FOCUSEM
	void focusInEvent           ( QFocusEvent* );
	void focusOutEvent          ( QFocusEvent* );
	void viewportMousePressEvent( QMouseEvent* );
	// DRAG & DROP
	void contentsMousePressEvent( QMouseEvent* );
	void contentsMouseMoveEvent ( QMouseEvent* );
	void contentsDragEnterEvent ( QDragEnterEvent* );
	void contentsDropEvent      ( QDropEvent* );
	void start_drag             ();
	// WYSWIETLANIE DANYCH W TABLICY
	void display_item_info      ( const QFileInfo& );
	void display_item_info      ( const QUrlInfo& );
	ViewTableItem* const create_tbl_item( const ItemAsText&, const bool );
	void add_dir_icon           ( ViewTableItem* const );
	bool can_display            ( const QString&, bool );
	void get_fname_fext         ( const QString&, QString&, QString& );
	void get_access             ( const QFileInfo&, QString& );
	void get_access             ( const QUrlInfo&, QString& );
	void get_size               ( const unsigned int, QString& );
	void get_date_time          ( const QDateTime&, QString&, QString& );
private slots:
	void selection_changed      ();
	void selection_mode_changed ();
	void context_menu           ( QListViewItem*, const QPoint&, int );
	void timeout                ();
signals:
	void cd_up                  ();
	void cd_home                ();
	void cd_root                ();
	void cd_refresh             ();
	void remove                 ();
	void F2                     ();
	void F3                     ();
	void F4                     ();
	void F5                     ();
	void F6                     ();
	void F8                     ();
	void F9                     ();
	void empty                  ();
	void selections_update      ( int );
	void next_dir               ();
	void next_file              ();
	void touch                  ();
	void disp_dir_size          ( ViewTableItem* );
};

//*******************************************************************
// current_item                                        PUBLIC inline
//*******************************************************************
inline ViewTableItem* ViewTable::current_item() const
{
	return dynamic_cast<ViewTableItem*>( currentItem() );
}
// return current_item

//*******************************************************************
// create_tbl_item                                    PRIVATE inline
//*******************************************************************
inline ViewTableItem* const ViewTable::create_tbl_item( const ItemAsText& in_item_as_text, const bool in_is_ftp )
{
	return new ViewTableItem
		(	this,
			in_item_as_text.info[ COL_FNAME  ],
			in_item_as_text.info[ COL_FEXT   ],
			in_item_as_text.info[ COL_ACCESS ],
			in_item_as_text.info[ COL_SIZE   ],
			in_item_as_text.info[ COL_DATE   ],
			in_item_as_text.info[ COL_TIME   ],
			in_item_as_text.info[ COL_OWNER  ],
			in_item_as_text.info[ COL_GROUP  ],
			in_is_ftp
		);
}
// end of create_tbl_item

//*******************************************************************
// add_dir_icon                                       PRIVATE inline
//*******************************************************************
inline void ViewTable::add_dir_icon( ViewTableItem* const in_item )
{
	if( in_item->is_dir() ) {
		QString icon_name = FOLDER_ICON;
		if( in_item->is_lfs() && !in_item->is_executable() && !in_item->is_readable() ) {
			icon_name = IFOLDER_ICON;
		}
		in_item->setPixmap( COL_FNAME, QPixmap::fromMimeSource( icon_name ));
	}
}
// end of create_tbl_item

#endif // INCLUDED_VIEWTABLE_H
