/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_SEARCHER_H
#define INCLUDED_SEARCHER_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QDIR_H
#include <qdir.h>
#define INCLUDED_QDIR_H
#endif // INCLUDED_QDIR_H

#ifndef INCLUDED_QFILEINFO_H
#include <qfileinfo.h>
#define INCLUDED_QFILEINFO_H
#endif // INCLUDED_QFILEINFO_H

#ifndef INCLUDED_QREGEXP_H
#include <qregexp.h>
#define INCLUDED_QREGEXP_H
#endif // INCLUDED_QREGEXP_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QComboBox;
class QPushButton;
class QLineEdit;
//class QTable;
class QListView;
class QLabel;
class QRadioButton;

/*------- class declaration:
-------------------------------------------------------------------*/
class Searcher : public QDialog
{
	Q_OBJECT
	
// ******* CONSTRUCTION *******
public:
	Searcher( QWidget* const in_widget );
private:
	Searcher( const Searcher& );
	Searcher& operator=( const Searcher& );
	
// ******* MEMBERS *******
private:
	static const QString CAPTION;
	static const int     OVER_STRETCH;
	static const int     SPACING_WIDTH;
	static const int     MARGIN_WIDTH;
	static const QString BTN_RETURN_LABEL;
	static const QString BEGIN_FROM_LABEL;
	static const QString WHAT_LABEL;
	static const QString GBOX_SETTINGS_LABEL;
	static const QString GBOX_RESULTS_LABEL;
	static const QString END_OF_SEARCH;
	static const QString HDR_FILE;
	static const QString HDR_DIR;

	QComboBox*           d_from_cbx;
	QComboBox*           d_what_cbx;
	QListView*           d_table;
	QLineEdit*           d_info_line;
	QPushButton* const   d_start_btn;
	QPushButton* const   d_break_btn;
	QPushButton* const   d_return_btn;
	QPushButton* const   d_cancel_btn;
	QPushButton*         d_tree_btn;
	QRadioButton*        d_sensitive_rbn;
	QRadioButton*        d_insensitive_rbn;
	bool                 d_break;
	QFileInfo            d_finfo;
	unsigned long        d_counter;
	QString              d_goto_path;
	
// ******* METHODS *******
public:
	const QString& get_goto_data() { return d_goto_path; }
private:
	void       polish();
	QComboBox* create_combo_box( QWidget* const in_parent );
	void       parse( const QString& in_path );
	void       befor();
	void       after();
	void       display( const QFileInfo* const in_finfo );
	void       display_path( const QString& in_path );
private slots:
	void       slot_start();
	void       slot_break();
	void       slot_goto();
	void       slot_cancel();
	void       slot_tree();
};

#endif // INCLUDED_SEARCHER_H
