/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_FILEINFO_H
#define INCLUDED_FILEINFO_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QOBJECT_H
#include <qobject.h>
#define INCLUDED_QOBJECT_H
#endif // INCLUDED_QOBJECT_H

/*------- class declaration:
-------------------------------------------------------------------*/
class FileInfo : public QObject
{
    Q_OBJECT

// ******* TYPES *******
public:
    typedef enum {
        ReadOwner   = 0x000000001,
        WriteOwner  = 0x000000010,
        ExeOwner    = 0x000000100,
        ReadGroup   = 0x000001000,
        WriteGroup  = 0x000010000,
        ExeGroup    = 0x000100000,
        ReadOther   = 0x001000000,
        WriteOther  = 0x010000000,
        ExeOther    = 0x100000000
    };

// ******* CONSTRUCTION / DESTRUCTION *******
public:
    FileInfo();
private:
    FileInfo( const FileInfo& );
    FileInfo& operator=( const FileInfo& );

// ******* MEMBERS *******
private:
    unsigned long m_perm;
    QString       m_fpath;
    unsigned long m_size;
    QDateTime     m_mod_datime;
};


#endif // INCLUDED_FILEINFO_H
