/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
// Created: 2005-05-08

#ifndef INCLUDED_MAINWINDOW_H
#define INCLUDED_MAINWINDOW_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QMAINWINDOW_H
#include <qmainwindow.h>
#define INCLUDED_QMAINWINDOW_H
#endif // INCLUDED_QMAINWINDOW_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QApplication;
class QAction;
class QPopupMenu;
class QToolBar;
class QStatusBar;
class QPushButton;
class QFrame;
class QTabBar;
class QWidgetStack;
class QSplitter;
class ViewWindow;
class Workspace;
class QTranslator;
class QTab;

/*------- class declaration:
-------------------------------------------------------------------*/
class MainWindow : public QMainWindow
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	MainWindow();
	~MainWindow();
private:
	MainWindow( const MainWindow& );
	MainWindow& operator=( const MainWindow& );

// ******* TYPES *******
public:
	enum
	{
		BTN_HELP = 0,
		BTN_ATTR,
		BTN_VIEW,
		BTN_EDIT,
		BTN_COPY,
		BTN_RENAME,
		BTN_MKDIR,
		BTN_DELETE,
		BTN_PACK,
		BTN_QUIT,
		BTN_NUMBER
	};
	
// ####### MEMBERS #######
private:
	static const QString APP_ICON;
	static const QString TabViewLabel;
	static const QString TabConsoleLabel;
	static const QString MenuSystemText;
	static const QString MenuOperText;
	static const QString MenuLangText;
	static const QString MenuHelpText;
	static const QString AboutQtMenuText;
	static const QString AboutMenuText;
	static const QString ReloadMenuText;
	static const QString RELOAD_MENU_ICON;
	static const QString FilterMenuText;
	static const QString FILTER_MENU_ACCEL;
	static const QString FILTER_MENU_ICON;
	static const QString NcMenuText;
	static const QString KdeMenuText;
	static const QString SystemInfoMenuText;
	static const QString SystemInfoIcon;
	
	static const QString SwitchMenuText;
	static const QString SwitchMenuIcon;
	static const QString SwitchMenuAccel;
	static const QString TabNewMenuText;
	static const QString TabNewMenuIcon;
	static const QString TabNewMenuAccel;
	static const QString TabRemoveMenuText;
	static const QString TabRemoveMenuIcon;
	static const QString TabRemoveMenuAccel;
	
	static const QString TreeMenuText;
	static const QString CmpFilesMenuText;
	static const QString CMP_FILES_MENU_ICON;
	static const QString CmpDirMenuText;
	
	static const QString DirSynchIcon;
	static const QString DirSynchMenuText;

	static const QString DateTimeMenuText;
	static const QString DATETIME_MENU_ICON;
	static const QString SelectMenuText;
	static const QString SELECT_MENU_ICON;
	static const QString UnselectMenuText;
	static const QString UNSELECT_MENU_ICON;
	static const QString ReversMenuText;
	static const QString REVERS_MENU_ICON;
	static const QString Md5CreateAccel;
	static const QString Md5CreateMenuText;
	static const QString Md5CheckAccel;
	static const QString Md5CheckMenuText;
	static const QString FtpStartMenuText;
	static const QString FTP_START_MENU_ICON;
	static const QString FtpEndMenuText;
	static const QString FTP_END_MENU_ICON;
	static const QString ConfigureMenuText;
	static const QString CONFIGURE_MENU_ICON;
	static const QString ExitMenuText;
	static const QString EXIT_MENU_ACCEL;
	static const QString EXIT_MENU_ICON;
	static const QString LANG_EN_MENU_TEXT;
	static const QString LANG_RU_MENU_TEXT;	
	static const QString LANG_PL_MENU_TEXT;
	static const QString LANG_DE_MENU_TEXT;
	static const QString LANG_ES_MENU_TEXT;
	static const QString CONFIG_GROUP_NAME;
	static const QString CONFIG_KEY_WIDTH;
	static const QString CONFIG_KEY_HEIGHT;

	QAction*    const d_action_about_qt;
	QAction*    const d_action_about;
	QAction*    const d_action_reload;
	QAction*    const d_action_filter;
	QAction*    const d_action_nc;
	QAction*    const d_action_kde;
	QAction*    const d_action_exit;
	QAction*    const d_action_system_info;
	QAction*    const d_action_switch;
	QAction*    const d_action_tab_new;
	QAction*    const d_action_tab_remove;
	QAction*    const d_action_tree;
	QAction*    const d_action_cmp_files;
	QAction*    const d_action_cmp_dirs;
	QAction*    const d_action_dir_synch;
	QAction*    const d_action_datetime;
	QAction*    const d_action_select;
	QAction*    const d_action_unselect;
	QAction*    const d_action_revers;
	QAction*    const d_action_md5_create;
	QAction*    const d_action_md5_check;
	QAction*    const d_action_ftp_start;
	QAction*    const d_action_configure;
	QAction*    const d_action_ftp_end;
	QAction*    const d_action_lang_en;
	QAction*    const d_action_lang_ru;	
	QAction*    const d_action_lang_pl;
	QAction*    const d_action_lang_de;
	QAction*    const d_action_lang_es;
	QPopupMenu* const d_popup_system;
	QPopupMenu* const d_popup_oper;
	QPopupMenu* const d_popup_lang;
	QPopupMenu* const d_popup_help;
	QToolBar*   const d_tool_bar;
	QTranslator* const d_translator;
	QPushButton*      d_function_buttons[BTN_NUMBER];
	Workspace*        d_workspace;
	bool              d_lang_doit;
	bool              d_selection_doit;

// ####### METHODS #######
private:
	void create_actions         ();
	void init_tool_bar          ();
	void init_menu              ( bool );
	void init_popup_system_menu ();
	void init_popup_oper_menu   ();
	void init_popup_lang_menu   ();
	void init_popup_help_menu   ();
	void create_work_area       ( QFrame* const parent );
	void create_button_area     ( QFrame* const parent );
	void read_settings          ();
	void write_settings         ();
	void polish                 ();
	void keyPressEvent          ( QKeyEvent* e );
	void closeEvent             ( QCloseEvent* e );
	void read_lang_info         ();
	void update_lang            ( bool = FALSE );
	void retranslate_strings    ( bool );
// ####### SLOTS #######
private slots:
	void F1                   ();
	void F10                  ();
	void about                ();
	void slot_ftp_start       ();
	void slot_ftp_end         ();
	void lang_en              ( bool );
	void lang_ru              ( bool );	
	void lang_pl              ( bool );
	void lang_de              ( bool );
	void lang_es              ( bool );
	void nc_selection         ( bool );
	void kde_selection        ( bool );
	void redraw_buttons       ();
	void system_info          ();
signals:
	void ftp_start            ();
	void ftp_end              ();
	void lang_changed         ();
	void selection_changed    ();
};

#endif // INCLUDED_MAINWINDOW_H
