/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_DIRSYNCH_H
#define INCLUDED_DIRSYNCH_H
 
/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_DIRSDIALOG_H
#include "DirsDialog.h"
#endif // INCLUDED_DIRSDIALOG_H

/*------- class declaration:
-------------------------------------------------------------------*/
class DirSynch : public DirsDialog
{
	Q_OBJECT

// ******* DEFINITIONS *******
private:
	enum { BufferSize = 8192 };
// ******* CONSTRUCTION *******
public:
	DirSynch( QWidget* const, const QString&, const QString& );
private:
	DirSynch( const DirSynch& );
	DirSynch& operator=( const DirSynch& );

// ******* MEMBERS *******
private:
	static const QString Caption;
	static const QString InfoCaption;
	static const QString NotReadableFile;
	static const QString OpenForReadError;
	static const QString OpenForWriteError;
	char                 d_buffer[ BufferSize ];

// ******* METHODS *******
private:
	bool create_dir ( const QString&, const QString& );
	bool copy_file  ( const QString&, const QString& );
private slots:
	void file_do_it( const QString&, bool, bool, const QString&, const QString& );
	void dir_do_it ( const QString&, bool, bool, const QString&, const QString& );
};

#endif // INCLUDED_DIRSYNCH_H
