/*
 * (c) Copyright 2000, 2002, 2004 -- Anders Torger
 *
 * This program is open source. For license terms, see the LICENSE file.
 *
 */
#ifndef _TIMESTAMP_H_
#define _TIMESTAMP_H_

#include <inttypes.h>
#include <time.h>

#if defined(__ARCH_GENERIC__)
#define TIMESTAMP_NOT_CLOCK_CYCLE_COUNTER
static inline void
timestamp(uint64_t *ts)
{
    *ts = (uint64_t)clock() * 1000;
}
#endif

#ifdef __ARCH_IA32__
static inline void
timestamp(uint64_t *ts)
{
    asm volatile("rdtsc" : "=a" (((uint32_t *)ts)[0]),
                 "=d" (((uint32_t *)ts)[1]));
}
#endif

#ifdef __ARCH_SPARC__
static inline void
timestamp(uint64_t *ts)
{
    asm volatile (
	"rd %%tick, %0    \n\t \
	 clruw %0, %1     \n\t \
	 srlx %0, 32, %0  \n\t"
	: "=r" (((uint32_t *)ts)[0]), "=r" (((uint32_t *)ts)[1])
	: "0" (((uint32_t *)ts)[0]), "1" (((uint32_t *)ts)[1]));
}
#endif

#endif
