// timerchain.h
// TimerChain
// String of multiple timers
// by Joe Flint

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _TIMERCHAIN_H
#define _TIMERCHAIN_H

#include <vector>
#include "timer.h"

using namespace std;

/** String of multiple timers
 *  Runs several timers, one after another.
 */
class TimerChain
{
	public:
		TimerChain();

		void add( const Timer & t );
		void clear();
		
		void start();
		bool started() const;	
		void stop();
		bool done();
		void resetDone();
		void update();
		void operator++(int);
		
		double change() const;
		double value() const;

	protected:
		double val, lastval;
		bool starton, doneon;
		vector< Timer > timers;
		unsigned int curtimer;
		
};
#endif
