/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CONSOLE_H
#define _CONSOLE_H

#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include "glhead.h"
#include "fontloader.h"
#include "timer.h"

using namespace std;

class Console
{
	public:
		static void setup();

		static void draw();
		static void show();
		static void hide();
		static void toggle();
      static bool isOn();

		static void clear();		
		static stringstream out;
   
      // For input
      static stringstream con_cmd;
      static void getKeyboardInput(bool *);
      static string fetchCommand();
      static void setCommand();
   
	protected:
		static Timer anim;
		static bool on;
		static double hideoff;
		static vector<string> buffer;
   
      static string currentCommand;
	   static bool cmdIsSet;
};
#endif
